/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioClipPlayer {
    private Hashtable<String, byte[]> m_audioClipData = new Hashtable();
    private Hashtable<String, byte[]> m_fallbackAudioClipData = new Hashtable();
    private Hashtable<String, ArrayList<Clip>> m_audioClips = new Hashtable();
    private boolean m_debug;

    public AudioClipPlayer(boolean bl) {
        this.m_debug = bl;
    }

    public void loadAudioClip(AudioClipPath audioClipPath) {
        this.loadAudioClip(audioClipPath.getUrl(), this.m_audioClipData);
        this.loadAudioClip(audioClipPath.getFallbackUrl(), this.m_fallbackAudioClipData);
    }

    private void loadAudioClip(URL uRL, Hashtable<String, byte[]> hashtable) {
        BufferedInputStream bufferedInputStream = null;
        if (uRL != null) {
            try {
                int n;
                Object object;
                if (this.m_debug) {
                    System.out.println(uRL.toString());
                }
                if (uRL.getProtocol().equals("jar")) {
                    object = (JarURLConnection)uRL.openConnection();
                    JarFile jarFile = ((JarURLConnection)object).getJarFile();
                    JarEntry jarEntry = ((JarURLConnection)object).getJarEntry();
                    n = (int)jarEntry.getSize();
                    if (this.m_debug) {
                        System.out.println("JAR: " + jarEntry.getName() + " - " + n);
                    }
                    bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                } else {
                    object = new File(uRL.toURI());
                    n = (int)((File)object).length();
                    if (this.m_debug) {
                        System.out.println("FileSystem: " + ((File)object).getName() + " - " + n);
                    }
                    bufferedInputStream = new BufferedInputStream(new FileInputStream((File)object));
                }
                object = new byte[n];
                ((InputStream)bufferedInputStream).read((byte[])object);
                ((InputStream)bufferedInputStream).close();
                hashtable.put(uRL.toString(), (byte[])object);
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception.getMessage());
            }
        }
    }

    public synchronized void playAudioClip(AudioClipPath audioClipPath) {
        block4: {
            if (audioClipPath.getUrl() != null || audioClipPath.getFallbackUrl() != null) {
                try {
                    Clip clip = this.getNextAvailableClip(audioClipPath);
                    if (clip != null) {
                        AudioClipThread audioClipThread = new AudioClipThread(clip);
                        audioClipThread.start();
                    }
                }
                catch (Exception exception) {
                    if (!this.m_debug) break block4;
                    System.out.println("Error: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }

    private Clip getNextAvailableClip(AudioClipPath audioClipPath) throws UnsupportedAudioFileException, IOException {
        Clip clip;
        block17: {
            clip = null;
            boolean bl = false;
            URL uRL = audioClipPath.getUrl();
            URL uRL2 = audioClipPath.getFallbackUrl();
            ArrayList<Clip> arrayList = this.m_audioClips.get(uRL.toString());
            boolean bl2 = false;
            if (arrayList == null) {
                arrayList = new ArrayList();
                bl = true;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                clip = arrayList.get(i);
                if (!clip.isActive()) {
                    if (this.m_debug) {
                        System.out.println("Using old: " + clip.toString() + " (" + arrayList.size() + ")");
                    }
                    clip.setFramePosition(0);
                    break;
                }
                clip = null;
            }
            if (clip == null) {
                try {
                    clip = this.createClipFromStream(uRL, this.m_audioClipData);
                    arrayList.add(clip);
                    if (this.m_debug) {
                        System.out.println("Getting new: " + uRL.toString() + " (" + arrayList.size() + ")");
                    }
                    if (bl) {
                        this.m_audioClips.put(uRL.toString(), arrayList);
                    }
                }
                catch (LineUnavailableException lineUnavailableException) {
                    bl2 = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl2 = true;
                }
                if (bl2) {
                    try {
                        clip = this.createClipFromStream(uRL2, this.m_fallbackAudioClipData);
                        arrayList.add(clip);
                        if (this.m_debug) {
                            System.out.println("Getting new fallback: " + uRL2.toString() + " (" + arrayList.size() + ")");
                        }
                        if (bl) {
                            this.m_audioClips.put(uRL.toString(), arrayList);
                        }
                    }
                    catch (LineUnavailableException lineUnavailableException) {
                        if (this.m_debug) {
                            System.out.println("Error: " + lineUnavailableException.getMessage());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!this.m_debug) break block17;
                        System.out.println("Error: " + illegalArgumentException.getMessage());
                    }
                }
            }
        }
        return clip;
    }

    private Clip createClipFromStream(URL uRL, Hashtable<String, byte[]> hashtable) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        byte[] byArray = hashtable.get(uRL.toString());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(byteArrayInputStream);
        Clip clip = AudioSystem.getClip();
        clip.open(audioInputStream);
        return clip;
    }

    public void printSupportedFormats() {
        try {
            Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                System.out.println(i + 1 + ". " + infoArray[i].getName() + " --> " + infoArray[i].getDescription());
                Line.Info[] infoArray2 = AudioSystem.getMixer(infoArray[i]).getSourceLineInfo();
                System.out.println("\tSource Lines:");
                for (int j = 0; j < infoArray2.length; ++j) {
                    System.out.println("\t" + (j + 1) + ". " + infoArray2[j].toString());
                }
                System.out.println();
                Line.Info[] infoArray3 = AudioSystem.getMixer(infoArray[i]).getTargetLineInfo();
                System.out.println("\tTarget Lines:");
                for (int j = 0; j < infoArray3.length; ++j) {
                    System.out.println("\t" + (j + 1) + ". " + infoArray3[j].toString());
                }
                System.out.println("\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

