/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class BattleShip
extends Container
implements MouseListener,
MouseMotionListener {
    private int m_iCellWidth;
    private int m_iType;
    private boolean m_bVertical;
    private int m_iDirection;
    private Point m_oPntMousePos;
    private boolean m_bLocked;
    private ArrayList<Point> m_alShots;
    private ArrayList<Point> m_alHits;
    private ArrayList<Point> m_fieldHits;
    private Polygon m_oPolCurrentShape;
    private int m_iHitCount;
    private int m_iMaxHits;
    private boolean m_bSunk;
    private boolean m_bEnemyShip;
    private Point m_oPntPos;
    private boolean m_bPlaying;
    private Dimension m_oDimOriginal;
    private boolean m_bHighlight;
    private CopyOnWriteArrayList<Point> m_alCheckPoint;
    private Color m_oColSunk;
    private Color m_oColHitMark;
    private Color m_oColShotMark;
    private Color m_oColHighlight;
    private boolean m_bForceVisibility;
    private BattleShipsField m_oPlParent;
    private Image m_oImgSegment;
    private Image m_oImgSegmentSunk;
    private int m_iMaxShipArea;

    public BattleShip(int n, int n2, boolean bl) {
        this.m_iCellWidth = n;
        this.m_iType = n2;
        this.m_iDirection = 1;
        this.m_oPntMousePos = new Point(0, 0);
        this.m_bLocked = false;
        this.m_bPlaying = false;
        this.m_alShots = new ArrayList();
        this.m_alHits = new ArrayList();
        this.m_alCheckPoint = new CopyOnWriteArrayList();
        this.m_fieldHits = new ArrayList();
        this.m_iHitCount = 0;
        this.m_iMaxHits = 0;
        this.m_bSunk = false;
        this.m_bEnemyShip = bl;
        this.m_oPntPos = new Point(0, 0);
        this.m_bHighlight = false;
        this.m_bForceVisibility = false;
        this.m_iMaxShipArea = 0;
        int n3 = 0;
        int n4 = 0;
        switch (this.m_iType) {
            case 1: {
                n3 = this.m_iCellWidth;
                n4 = this.m_iCellWidth * 2;
                break;
            }
            case 2: {
                n3 = this.m_iCellWidth;
                n4 = this.m_iCellWidth * 3;
                break;
            }
            case 3: {
                n3 = this.m_iCellWidth * 2;
                n4 = this.m_iCellWidth * 3;
                break;
            }
            case 4: {
                n3 = this.m_iCellWidth;
                n4 = this.m_iCellWidth * 5;
                break;
            }
            case 5: {
                n3 = this.m_iCellWidth * 2;
                n4 = this.m_iCellWidth * 4;
                break;
            }
            case 6: {
                n3 = this.m_iCellWidth;
                n4 = this.m_iCellWidth * 6;
                this.m_iMaxHits = 6;
            }
        }
        this.m_oDimOriginal = new Dimension(n3, n4);
        this.setSize(this.m_oDimOriginal);
        this.setShape();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setColorSunk(Color color) {
        this.m_oColSunk = color;
    }

    public void setColorHitMark(Color color) {
        this.m_oColHitMark = color;
    }

    public void setColorHighlight(Color color) {
        this.m_oColHighlight = color;
    }

    public void setColorShotMark(Color color) {
        this.m_oColShotMark = color;
    }

    public void setImageSegment(Image image) {
        this.m_oImgSegment = image;
    }

    public void setImageSegmentSunk(Image image) {
        this.m_oImgSegmentSunk = image;
    }

    public void setForceVisibility() {
        this.m_bForceVisibility = true;
        this.repaint();
    }

    @Override
    public void setForeground(Color color) {
        this.m_oPlParent = (BattleShipsField)this.getParent();
        super.setForeground(color);
    }

    private void buildDiagonalShip() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        ArrayList arrayList6 = new ArrayList();
        int n2 = Math.round(this.m_oDimOriginal.height / this.m_iCellWidth);
        for (n = 0; n <= n2; ++n) {
            Integer n3 = new Integer(n);
            if (Math.IEEEremainder(n, 2.0) == 0.0) {
                arrayList.add(0, n3);
                arrayList.add(0, n3);
                continue;
            }
            arrayList2.add(n3);
            arrayList2.add(n3);
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            if (this.m_iDirection == 4 && Math.IEEEremainder(n2, 2.0) == 0.0) {
                arrayList4.add(listIterator.next());
                continue;
            }
            arrayList4.add(0, listIterator.next());
        }
        listIterator = arrayList2.listIterator();
        while (listIterator.hasNext()) {
            if (this.m_iDirection == 4 && Math.IEEEremainder(n2, 2.0) == 0.0) {
                arrayList5.add(listIterator.next());
                continue;
            }
            arrayList5.add(0, listIterator.next());
        }
        if (this.m_iDirection == 4 && Math.IEEEremainder(n2, 2.0) != 0.0) {
            listIterator = arrayList5.listIterator();
            while (listIterator.hasNext()) {
                arrayList6.add(listIterator.next());
            }
            listIterator = arrayList4.listIterator();
            while (listIterator.hasNext()) {
                arrayList6.add(listIterator.next());
            }
        } else {
            listIterator = arrayList4.listIterator();
            while (listIterator.hasNext()) {
                arrayList6.add(listIterator.next());
            }
            listIterator = arrayList5.listIterator();
            while (listIterator.hasNext()) {
                arrayList6.add(listIterator.next());
            }
        }
        Integer n4 = (Integer)arrayList.remove(arrayList.size() - 1);
        arrayList2.add(0, n4);
        listIterator = arrayList2.listIterator();
        while (listIterator.hasNext()) {
            arrayList3.add(listIterator.next());
        }
        listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            arrayList3.add(listIterator.next());
        }
        Integer[] integerArray = new Integer[arrayList3.size()];
        integerArray = arrayList3.toArray(integerArray);
        Integer[] integerArray2 = new Integer[arrayList6.size()];
        integerArray2 = arrayList6.toArray(integerArray2);
        this.m_oPolCurrentShape = new Polygon();
        for (n = 0; n < integerArray.length; ++n) {
            this.m_oPolCurrentShape.addPoint(integerArray[n] * this.m_iCellWidth, integerArray2[n] * this.m_iCellWidth);
        }
    }

    private void setSize() {
        block0 : switch (this.m_iType) {
            case 3: 
            case 5: {
                switch (this.m_iDirection) {
                    case 1: 
                    case 3: {
                        this.setSize(this.m_oDimOriginal.width, this.m_oDimOriginal.height);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.setSize(this.m_oDimOriginal.height, this.m_oDimOriginal.width);
                    }
                }
                break;
            }
            default: {
                switch (this.m_iDirection) {
                    case 1: {
                        this.setSize(this.m_oDimOriginal.width, this.m_oDimOriginal.height);
                        break block0;
                    }
                    case 2: 
                    case 4: {
                        this.setSize(this.m_oDimOriginal.height, this.m_oDimOriginal.height);
                        break block0;
                    }
                    case 3: {
                        this.setSize(this.m_oDimOriginal.height, this.m_oDimOriginal.width);
                    }
                }
            }
        }
    }

    private void setMaxShipArea(int n, int n2, boolean bl) {
        this.m_iMaxShipArea = bl ? this.m_iCellWidth * (n * 5 + this.m_iCellWidth * 4) : (n + this.m_iCellWidth) * (n2 + this.m_iCellWidth);
    }

    private void setShape() {
        int n;
        Rectangle rectangle = this.getBounds();
        block0 : switch (this.m_iType) {
            case 3: {
                if (this.m_iMaxShipArea == 0) {
                    this.setMaxShipArea(this.m_oDimOriginal.width, this.m_oDimOriginal.height, false);
                }
                switch (this.m_iDirection) {
                    case 1: {
                        this.m_oPolCurrentShape = new Polygon(new int[]{0, Math.round(rectangle.width / 2), Math.round(rectangle.width / 2), rectangle.width, rectangle.width, Math.round(rectangle.width / 2), Math.round(rectangle.width / 2), 0}, new int[]{0, 0, Math.round(rectangle.height / 3), Math.round(rectangle.height / 3), Math.round(rectangle.height / 3) * 2, Math.round(rectangle.height / 3) * 2, rectangle.height, rectangle.height}, 8);
                        break;
                    }
                    case 2: {
                        this.m_oPolCurrentShape = new Polygon(new int[]{0, rectangle.width, rectangle.width, Math.round(rectangle.width / 3) * 2, Math.round(rectangle.width / 3) * 2, Math.round(rectangle.width / 3), Math.round(rectangle.width / 3), 0}, new int[]{0, 0, Math.round(rectangle.height / 2), Math.round(rectangle.height / 2), rectangle.height, rectangle.height, Math.round(rectangle.height / 2), Math.round(rectangle.height / 2)}, 8);
                        break;
                    }
                    case 3: {
                        this.m_oPolCurrentShape = new Polygon(new int[]{0, Math.round(rectangle.width / 2), Math.round(rectangle.width / 2), rectangle.width, rectangle.width, Math.round(rectangle.width / 2), Math.round(rectangle.width / 2), 0}, new int[]{Math.round(rectangle.height / 3), Math.round(rectangle.height / 3), 0, 0, rectangle.height, rectangle.height, Math.round(rectangle.height / 3) * 2, Math.round(rectangle.height / 3) * 2}, 8);
                        break;
                    }
                    case 4: {
                        this.m_oPolCurrentShape = new Polygon(new int[]{0, Math.round(rectangle.width / 3), Math.round(rectangle.width / 3), Math.round(rectangle.width / 3) * 2, Math.round(rectangle.width / 3) * 2, rectangle.width, rectangle.width, 0}, new int[]{Math.round(rectangle.height / 2), Math.round(rectangle.height / 2), 0, 0, Math.round(rectangle.height / 2), Math.round(rectangle.height / 2), rectangle.height, rectangle.height}, 8);
                    }
                }
                break;
            }
            case 5: {
                if (this.m_iMaxShipArea == 0) {
                    this.setMaxShipArea(this.m_oDimOriginal.width, this.m_oDimOriginal.height, false);
                }
                switch (this.m_iDirection) {
                    case 1: 
                    case 3: {
                        this.m_oPolCurrentShape = new Polygon(new int[]{0, Math.round(rectangle.width / 2), Math.round(rectangle.width / 2), rectangle.width, rectangle.width, Math.round(rectangle.width / 2), Math.round(rectangle.width / 2), 0}, new int[]{0, 0, Math.round(rectangle.height / 4), Math.round(rectangle.height / 4), rectangle.height, rectangle.height, Math.round(rectangle.height / 4) * 3, Math.round(rectangle.height / 4) * 3}, 8);
                        break;
                    }
                    case 2: 
                    case 4: {
                        this.m_oPolCurrentShape = new Polygon(new int[]{0, Math.round(rectangle.width / 4), Math.round(rectangle.width / 4), rectangle.width, rectangle.width, Math.round(rectangle.width / 4) * 3, Math.round(rectangle.width / 4) * 3, 0}, new int[]{Math.round(rectangle.height / 2), Math.round(rectangle.height / 2), 0, 0, Math.round(rectangle.height / 2), Math.round(rectangle.height / 2), rectangle.height, rectangle.height}, 8);
                    }
                }
                break;
            }
            default: {
                if (this.m_iMaxShipArea == 0) {
                    this.setMaxShipArea(this.m_oDimOriginal.height, this.m_oDimOriginal.height, true);
                }
                switch (this.m_iDirection) {
                    case 1: 
                    case 3: {
                        this.m_oPolCurrentShape = new Polygon(new int[]{0, rectangle.width, rectangle.width, 0}, new int[]{0, 0, rectangle.height, rectangle.height}, 4);
                        break block0;
                    }
                    case 2: 
                    case 4: {
                        this.buildDiagonalShip();
                    }
                }
            }
        }
        this.m_alCheckPoint.clear();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        for (int i = n = Math.round(this.m_iCellWidth / 2); i < n2; i += this.m_iCellWidth) {
            for (int j = n; j < n3; j += this.m_iCellWidth) {
                Point point = new Point(i, j);
                if (!this.m_oPolCurrentShape.contains(point)) continue;
                this.m_alCheckPoint.add(point);
            }
        }
        if (this.m_iMaxHits == 0) {
            this.m_iMaxHits = this.m_alCheckPoint.size();
        }
    }

    public void setPlaying(boolean bl) {
        this.m_bPlaying = bl;
    }

    public void setPosition(int n, int n2) {
        this.m_oPntPos.x = n;
        this.m_oPntPos.y = n2;
        this.setLocation(n * this.m_iCellWidth, n2 * this.m_iCellWidth);
    }

    public Point getPosition() {
        return this.m_oPntPos;
    }

    public void setLocked(boolean bl) {
        this.m_bLocked = bl;
    }

    public int getType() {
        return this.m_iType;
    }

    public int getDirection() {
        return this.m_iDirection;
    }

    public void setDirection(int n) {
        this.m_iDirection = n;
        this.setSize();
        this.setShape();
    }

    public void reset(int n) {
        if (n == 3) {
            this.m_bSunk = false;
        } else {
            this.m_bLocked = false;
            this.m_bPlaying = false;
            this.m_iHitCount = 0;
            this.m_bSunk = false;
            this.m_alShots.clear();
            this.m_alHits.clear();
            this.m_fieldHits.clear();
        }
    }

    public boolean shoot(Point point) {
        Point point2;
        Rectangle rectangle = this.getBounds();
        int n = point.x * this.m_iCellWidth - rectangle.x;
        int n2 = point.y * this.m_iCellWidth - rectangle.y;
        boolean bl = this.m_oPolCurrentShape.contains(n + Math.round(this.m_iCellWidth / 2), n2 + Math.round(this.m_iCellWidth / 2));
        if (bl && !this.m_alHits.contains(point2 = new Point(n, n2))) {
            this.addAndPaintHit(point2);
            this.m_fieldHits.add(point);
            this.m_oPlParent.passShot(this.m_bEnemyShip, point, bl, this.m_bSunk, this.m_iType, this.m_fieldHits);
        }
        return bl;
    }

    private void shoot(int n, int n2) {
        Point point = new Point(Math.round(n / this.m_iCellWidth) * this.m_iCellWidth, Math.round(n2 / this.m_iCellWidth) * this.m_iCellWidth);
        boolean bl = this.m_oPolCurrentShape.contains(point.x + Math.round(this.m_iCellWidth / 2), point.y + Math.round(this.m_iCellWidth / 2));
        Point point2 = null;
        if (bl) {
            if (!this.m_bSunk && !this.m_alHits.contains(point)) {
                this.addAndPaintHit(point);
                point2 = this.getLocation();
                this.m_oPlParent.passShot(this.m_bEnemyShip, new Point(Math.round((n + point2.x) / this.m_iCellWidth), Math.round((n2 + point2.y) / this.m_iCellWidth)), true, this.m_bSunk, this.m_iType, this.m_fieldHits);
            }
        } else if (!this.m_alShots.contains(point)) {
            this.m_alShots.add(point);
            point2 = this.getLocation();
            this.m_oPlParent.passShot(this.m_bEnemyShip, new Point(Math.round((n + point2.x) / this.m_iCellWidth), Math.round((n2 + point2.y) / this.m_iCellWidth)), false, false, this.m_iType, this.m_fieldHits);
        }
    }

    private void addAndPaintHit(Point point) {
        Graphics graphics = this.getGraphics();
        ++this.m_iHitCount;
        this.m_alHits.add(point);
        if (this.m_iHitCount == this.m_iMaxHits) {
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.m_bSunk = true;
            if (!this.m_bEnemyShip) {
                this.paintShipSegments(graphics);
            }
            this.paintHits(graphics);
        } else if (this.isVisible()) {
            this.paintHit(graphics, point, this.m_oColHitMark);
        }
    }

    public void setSunk() {
        this.m_bSunk = true;
        this.paintShipSegments(this.getGraphics());
    }

    public void setHighlight(boolean bl) {
        this.m_bHighlight = bl;
        this.repaint();
    }

    public boolean intersects(BattleShip battleShip, boolean bl) {
        Point point = this.getLocation();
        Point point2 = battleShip.getLocation();
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        boolean bl2 = false;
        Point[] pointArray = battleShip.getCheckPoints();
        for (int i = 0; i < pointArray.length; ++i) {
            Point point3 = new Point(pointArray[i].x + n, pointArray[i].y + n2);
            if (this.m_oPolCurrentShape.contains(point3)) {
                bl2 = true;
                break;
            }
            if (!bl || !this.m_oPolCurrentShape.contains(new Point(point3.x + this.m_iCellWidth, point3.y)) && !this.m_oPolCurrentShape.contains(new Point(point3.x + this.m_iCellWidth, point3.y - this.m_iCellWidth)) && !this.m_oPolCurrentShape.contains(new Point(point3.x, point3.y - this.m_iCellWidth)) && !this.m_oPolCurrentShape.contains(new Point(point3.x - this.m_iCellWidth, point3.y - this.m_iCellWidth)) && !this.m_oPolCurrentShape.contains(new Point(point3.x - this.m_iCellWidth, point3.y)) && !this.m_oPolCurrentShape.contains(new Point(point3.x - this.m_iCellWidth, point3.y + this.m_iCellWidth)) && !this.m_oPolCurrentShape.contains(new Point(point3.x, point3.y + this.m_iCellWidth)) && !this.m_oPolCurrentShape.contains(new Point(point3.x + this.m_iCellWidth, point3.y + this.m_iCellWidth))) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public Point[] getCheckPoints() {
        Point[] pointArray = new Point[this.m_alCheckPoint.size()];
        pointArray = this.m_alCheckPoint.toArray(pointArray);
        return pointArray;
    }

    public boolean getSunk() {
        return this.m_bSunk;
    }

    public int getMaxShipArea() {
        return this.m_iMaxShipArea;
    }

    public ArrayList<Point> getPossibleHitpoints() {
        int n = Math.round(this.m_iCellWidth / 2);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < this.m_alCheckPoint.size(); ++i) {
            Point point = this.m_alCheckPoint.get(i);
            int n2 = (point.x - n) / this.m_iCellWidth + this.m_oPntPos.x;
            int n3 = (point.y - n) / this.m_iCellWidth + this.m_oPntPos.y;
            arrayList.add(new Point(n2, n3));
        }
        return arrayList;
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (!this.m_bEnemyShip || this.m_bForceVisibility) {
            this.paintShipSegments(graphics);
        }
        this.paintHits(graphics);
        if (!this.m_bEnemyShip && this.m_bHighlight) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.m_oColHighlight);
            graphics.drawRect(1, 1, dimension.width - 2, dimension.height - 2);
            graphics.drawRect(2, 2, dimension.width - 4, dimension.height - 4);
        }
        super.paint(graphics);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.m_bEnemyShip && !this.m_bLocked) {
            this.m_bHighlight = true;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.m_bEnemyShip && !this.m_bLocked) {
            this.m_bHighlight = false;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            if (!this.m_bLocked) {
                Rectangle rectangle = this.getBounds();
                Rectangle rectangle2 = this.m_oPlParent.getBounds();
                if (rectangle.x + rectangle.height <= rectangle2.width && rectangle.y + rectangle.width <= rectangle2.height) {
                    this.m_iDirection = this.m_iDirection == 4 ? 1 : ++this.m_iDirection;
                    this.setSize();
                    this.setShape();
                }
            }
        } else if (mouseEvent.getModifiers() == 16 && this.m_bEnemyShip && this.m_bPlaying) {
            this.shoot(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16 && !this.m_bLocked) {
            this.m_oPntMousePos.x = mouseEvent.getX();
            this.m_oPntMousePos.y = mouseEvent.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!(mouseEvent.getModifiers() != 16 && mouseEvent.getModifiers() != 0 || this.m_bLocked)) {
            int n;
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = this.m_oPlParent.getBounds();
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = rectangle.x + (n2 - this.m_oPntMousePos.x);
            if (n4 < 0 || n4 > rectangle2.width - rectangle.width + Math.round(this.m_iCellWidth / 2)) {
                n4 = rectangle.x;
            }
            if ((n = rectangle.y + (n3 - this.m_oPntMousePos.y)) < 0 || n > rectangle2.height - rectangle.height + Math.round(this.m_iCellWidth / 2)) {
                n = rectangle.y;
            }
            this.setPosition(Math.round(n4 / this.m_iCellWidth), Math.round(n / this.m_iCellWidth));
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void paintShipSegments(Graphics graphics) {
        Image image;
        Color color;
        Point point = null;
        if (graphics == null) {
            return;
        }
        if (this.m_bSunk) {
            color = this.m_oColSunk;
            image = this.m_oImgSegmentSunk;
        } else {
            color = this.getForeground();
            image = this.m_oImgSegment;
        }
        if (image == null) {
            graphics.setColor(color);
            graphics.fillPolygon(this.m_oPolCurrentShape);
        } else {
            ListIterator<Point> listIterator = this.m_alCheckPoint.listIterator();
            int n = 0;
            while (listIterator.hasNext()) {
                ++n;
                point = listIterator.next();
                graphics.drawImage(image, point.x - Math.round(this.m_iCellWidth / 2) + 1, point.y - Math.round(this.m_iCellWidth / 2) + 1, this);
            }
        }
    }

    private void paintHits(Graphics graphics) {
        Point point = null;
        ListIterator<Point> listIterator = this.m_alHits.listIterator();
        while (listIterator.hasNext()) {
            point = listIterator.next();
            this.paintHit(graphics, point, this.m_oColHitMark);
        }
    }

    private void paintHit(Graphics graphics, Point point, Color color) {
        if (graphics == null) {
            return;
        }
        Image image = this.m_bSunk ? this.m_oImgSegmentSunk : this.m_oImgSegment;
        if (this.m_bEnemyShip && !this.m_bForceVisibility) {
            graphics.drawImage(image, point.x + 1, point.y + 1, this);
        }
        graphics.setColor(color);
        graphics.drawLine(point.x + 1, point.y + 1, point.x + this.m_iCellWidth - 1, point.y + this.m_iCellWidth - 1);
        graphics.drawLine(point.x + 1, point.y + this.m_iCellWidth - 1, point.x + this.m_iCellWidth - 1, point.y + 1);
        graphics.drawLine(point.x + 2, point.y + 1, point.x + this.m_iCellWidth - 1, point.y + this.m_iCellWidth - 2);
        graphics.drawLine(point.x + 1, point.y + 2, point.x + this.m_iCellWidth - 2, point.y + this.m_iCellWidth - 1);
        graphics.drawLine(point.x + 2, point.y + this.m_iCellWidth - 1, point.x + this.m_iCellWidth - 1, point.y + 2);
        graphics.drawLine(point.x + 1, point.y + this.m_iCellWidth - 2, point.x + this.m_iCellWidth - 2, point.y + 1);
    }
}

