/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

public class BattleShipsApplication
extends Frame
implements BattleShipsParentContainer {
    private BattleShipsPanel m_oBtlShips;
    private BattleShipsUtility m_oUtil;
    private Properties m_propCookies;
    private String m_serverName;
    private ClassLoader m_cl;
    private static final String DEFAULT_SERVER = "battleships.dynv6.net";
    private static final String COOKIE_FILE = "cookies.txt";

    public static void main(String[] stringArray) {
        BattleShipsApplication battleShipsApplication = new BattleShipsApplication(stringArray);
    }

    public BattleShipsApplication(String[] stringArray) {
        CliArgs cliArgs = new CliArgs(stringArray);
        boolean bl = cliArgs.switchPresent("-debug");
        String string = cliArgs.switchValue("-action", "");
        String string2 = cliArgs.switchValue("-configfile", "");
        boolean bl2 = string.equals("startbot");
        boolean bl3 = string.equals("startserver");
        this.m_oUtil = new BattleShipsUtility();
        if (!string2.equals("")) {
            this.m_oUtil.setServerConfigFile(string2);
        }
        this.m_propCookies = new Properties();
        this.m_cl = this.getClass().getClassLoader();
        this.readCookieFile();
        this.m_serverName = this.getCookie("ServerName", DEFAULT_SERVER);
        if (this.m_oUtil.readParameters()) {
            this.setLayout(null);
            this.setResizable(false);
            this.setTitle(this.getParameter("String_Title"));
            this.enableEvents(64L);
            this.m_oBtlShips = (BattleShipsPanel)this.add(new BattleShipsPanel(false, bl));
            this.setVisible(true);
            this.setSize(640, 480);
            this.setIcons();
            this.m_oBtlShips.setStartBot(bl2);
            this.m_oBtlShips.setStartServer(bl3);
            this.m_oBtlShips.init();
        } else {
            System.err.println(this.m_oUtil.getErrorMessage());
            System.exit(1);
        }
    }

    @Override
    public String getParameter(String string, String string2) {
        return this.m_oUtil.getParameter(string, string2);
    }

    @Override
    public String getParameter(String string) {
        return this.m_oUtil.getParameter(string);
    }

    @Override
    public String getHost() {
        return this.m_serverName;
    }

    @Override
    public URL getAudioClipUrl(String string) {
        URL uRL = null;
        File file = new File(string);
        try {
            uRL = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error: Problem with sound file: " + file.toString());
        }
        return uRL;
    }

    @Override
    public Image getImage(String string) {
        Image image = null;
        URL uRL = this.getResource(string);
        if (uRL != null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        if (image == null) {
            System.err.println("Error: Missing file " + string);
            System.exit(1);
        }
        return image;
    }

    private void setIcons() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(this.getImage("res/icon16x16.png"));
        arrayList.add(this.getImage("res/icon32x32.png"));
        this.setIconImages(arrayList);
    }

    private URL getResource(String string) {
        return this.m_cl.getResource(string);
    }

    @Override
    public void setNormalState() {
        this.setState(0);
        this.toFront();
    }

    private void readCookieFile() {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(COOKIE_FILE));
            this.m_propCookies.load(fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeCookieFile() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(COOKIE_FILE));
            this.m_propCookies.store(fileOutputStream, BattleShipsUtility.getCopyright());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getCookie(String string) {
        return this.getCookie(string, "");
    }

    @Override
    public String getCookie(String string, String string2) {
        return this.m_propCookies.getProperty(string, string2);
    }

    @Override
    public void setCookie(String string, String string2, int n) {
        this.m_propCookies.setProperty(string, string2);
        this.writeCookieFile();
    }

    @Override
    public void setWindowTitle(String string) {
        String string2 = this.getParameter("String_Title");
        if (!string.equals("")) {
            string2 = string2 + " - " + string;
        }
        this.setTitle(string2);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.m_oBtlShips.stop();
            System.exit(0);
        }
    }
}

