/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.net.URL;

public class BattleShipsBot
extends Frame
implements BattleShipsParentContainer {
    private BattleShipsPanel m_oBtlShips;
    private BattleShipsUtility m_oUtil;
    private String m_serverName;
    private ClassLoader m_cl;
    private static final String DEFAULT_SERVER = "localhost";
    private static final String DEFAULT_PLAYER_NAME = "BattleshipsBot";
    private static final int DEFAULT_BOT_TIMEOUT_SECONDS = 600;

    public static void main(String[] stringArray) {
        BattleShipsBot battleShipsBot = new BattleShipsBot(stringArray);
    }

    public BattleShipsBot(String[] stringArray) {
        int n;
        CliArgs cliArgs = new CliArgs(stringArray);
        boolean bl = !cliArgs.switchPresent("-invisible");
        String string = cliArgs.switchValue("-name", DEFAULT_PLAYER_NAME);
        this.m_serverName = cliArgs.switchValue("-server", DEFAULT_SERVER);
        int n2 = cliArgs.switchIntValue("-port", 666);
        boolean bl2 = cliArgs.switchPresent("-autobot");
        boolean bl3 = cliArgs.switchPresent("-debug");
        try {
            n = cliArgs.switchIntValue("-timeout", 600);
        }
        catch (NumberFormatException numberFormatException) {
            n = 600;
        }
        this.m_oUtil = new BattleShipsUtility();
        this.m_cl = this.getClass().getClassLoader();
        if (this.m_oUtil.readParameters()) {
            this.setLayout(null);
            this.setResizable(false);
            this.setTitle(string);
            this.enableEvents(64L);
            this.m_oBtlShips = (BattleShipsPanel)this.add(new BattleShipsPanel(true, bl3));
            if (bl) {
                this.setVisible(true);
                this.setSize(640, 480);
            }
            this.m_oBtlShips.setIsBot(true, bl2, n2);
            this.m_oBtlShips.init();
            this.m_oBtlShips.setPlayerName(string);
            this.m_oBtlShips.setTimeOutSeconds(n);
        } else {
            System.err.println(this.m_oUtil.getErrorMessage());
            System.exit(1);
        }
    }

    @Override
    public String getParameter(String string, String string2) {
        return this.m_oUtil.getParameter(string, string2);
    }

    @Override
    public String getParameter(String string) {
        return this.m_oUtil.getParameter(string);
    }

    @Override
    public String getHost() {
        return this.m_serverName == null ? DEFAULT_SERVER : this.m_serverName;
    }

    @Override
    public URL getAudioClipUrl(String string) {
        return null;
    }

    @Override
    public Image getImage(String string) {
        Image image = null;
        URL uRL = this.getResource(string);
        if (uRL != null) {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        if (image == null) {
            System.err.println("Error: Missing file " + string);
            System.exit(1);
        }
        return image;
    }

    private URL getResource(String string) {
        return this.m_cl.getResource(string);
    }

    @Override
    public void setNormalState() {
        this.setState(0);
        this.toFront();
    }

    @Override
    public String getCookie(String string) {
        return "";
    }

    @Override
    public String getCookie(String string, String string2) {
        return "";
    }

    @Override
    public void setCookie(String string, String string2, int n) {
    }

    @Override
    public void setWindowTitle(String string) {
        if (string.equals("")) {
            string = DEFAULT_PLAYER_NAME;
        }
        this.setTitle(string);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.m_oBtlShips.stop();
            System.exit(0);
        }
    }
}

