/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;

public class BattleShipsBotLogic {
    private int m_fieldWidth;
    private ArrayList<Point> m_totalShotPoints = new ArrayList();
    private ArrayList<Point> m_hitPoints = new ArrayList();
    private ArrayList<BotShot> m_surrShotPoints = new ArrayList();
    private ArrayList<Point> m_rowShotPoints = new ArrayList();
    private ArrayList<Point> m_totalHitPoints = new ArrayList();
    private Point m_firstPoint;
    private Point m_lastHitPoint;
    private Point m_lastShot;
    private BattleShipsField m_plTestShips;
    private ArrayList<BotShot> m_firingSolutions;
    private ArrayList<Point> m_lastFiringSolution;
    private BattleShipsField m_plEnemyScore;
    private boolean m_seekEdges;
    private boolean m_debug;
    public static final int BOT_DELAY = 200;
    private static final double EDGE_SHOT_PROBABILITY = 0.4;

    public BattleShipsBotLogic(int n, boolean bl) {
        this.m_fieldWidth = n;
        this.m_debug = bl;
        this.m_firingSolutions = new ArrayList();
        this.m_lastFiringSolution = new ArrayList();
        this.m_seekEdges = false;
        this.fillTotalShotPoints();
    }

    public void setTestShipsPanel(BattleShipsField battleShipsField) {
        this.m_plTestShips = battleShipsField;
    }

    public void setEnemyScorePanel(BattleShipsField battleShipsField) {
        this.m_plEnemyScore = battleShipsField;
    }

    public Point getNextShot() {
        Point point;
        int n = this.m_rowShotPoints.size();
        int n2 = this.m_surrShotPoints.size();
        if (n > 0) {
            point = this.m_rowShotPoints.get(n - 1);
            this.m_rowShotPoints.remove(n - 1);
            this.removeSurrShotPoint(point);
            this.m_totalShotPoints.remove(point);
            this.printDebug("El count after 1: (" + point.toString() + ")" + this.m_totalShotPoints.size());
        } else if (n2 > 0) {
            point = this.getSurrShotPoint();
            this.m_totalShotPoints.remove(point);
            this.printDebug("El count after 2: (" + point.toString() + ")" + this.m_totalShotPoints.size());
        } else {
            if (this.m_firstPoint != null) {
                point = this.m_firstPoint;
                this.m_totalShotPoints.remove(point);
                this.m_firstPoint = null;
            } else {
                point = this.getNextShotPoint();
            }
            this.printDebug("El count after 4: (" + point.toString() + ")" + this.m_totalShotPoints.size());
        }
        return point;
    }

    public void reportLastShot(Point point, boolean bl, boolean bl2, ArrayList<Point> arrayList) {
        int n;
        Point point2;
        int n2;
        boolean bl3 = false;
        if (bl) {
            this.m_totalHitPoints.add(point);
        }
        if (bl2) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                point2 = arrayList.get(n2);
                this.m_hitPoints.remove(point2);
            }
            n = this.m_hitPoints.size();
            if (n > 0) {
                this.m_rowShotPoints.clear();
                this.m_surrShotPoints.clear();
                this.m_firingSolutions.clear();
                this.m_lastFiringSolution.clear();
                for (n2 = 0; n2 < n; ++n2) {
                    point2 = this.m_hitPoints.get(n2);
                    this.printDebug("next shot point: " + point2.toString());
                    this.fillSurrShotPoints(point2, this.m_surrShotPoints);
                }
            }
        }
        if (bl2 && this.m_hitPoints.size() == 0) {
            this.m_rowShotPoints.clear();
            this.m_surrShotPoints.clear();
            this.m_firingSolutions.clear();
            this.m_lastFiringSolution.clear();
            this.m_lastHitPoint = null;
        } else if (bl || this.m_lastHitPoint != null) {
            this.m_lastShot = point;
            if (bl) {
                if (point.x == 0 || point.y == 0 || point.x == this.m_fieldWidth - 1 || point.y == this.m_fieldWidth - 1) {
                    this.m_seekEdges = true;
                }
                if (!bl2) {
                    this.m_lastHitPoint = point;
                    this.m_hitPoints.add(point);
                    for (n2 = 0; n2 < this.m_hitPoints.size(); ++n2) {
                        point2 = this.m_hitPoints.get(n2);
                        this.printDebug("hit point after add: " + point2.toString());
                    }
                }
            } else {
                point = this.m_lastHitPoint;
                this.m_lastHitPoint = null;
            }
            if (!bl2) {
                if (!(this.m_hitPoints.size() != 3 || this.m_lastFiringSolution.contains(this.m_lastShot) || this.m_plEnemyScore.hasActiveShips(4) || this.m_plEnemyScore.hasActiveShips(6))) {
                    this.m_rowShotPoints.clear();
                }
                if (this.m_lastFiringSolution.contains(point) && bl && this.m_rowShotPoints.size() == 0) {
                    this.m_firingSolutions.clear();
                    this.manageFiringSolutions(5);
                } else if (this.m_lastFiringSolution.contains(this.m_lastShot) && (!bl || this.m_rowShotPoints.size() == 0)) {
                    if (!bl) {
                        this.m_rowShotPoints.clear();
                    }
                    if (this.m_hitPoints.size() >= 3) {
                        this.m_firingSolutions.clear();
                    }
                    this.applyFiringSolutionLogic("1");
                }
            }
            if (this.m_rowShotPoints.size() == 0) {
                if (!bl2) {
                    this.fillSurrShotPoints(point, this.m_surrShotPoints);
                    this.printDebug("individual next shot point: " + point.toString());
                }
                if ((n = this.m_hitPoints.size()) > 1) {
                    Point point3 = this.m_hitPoints.get(0);
                    Point point4 = this.m_hitPoints.get(n - 1);
                    if (point3.y > point4.y) {
                        point2 = point3;
                        point3 = point4;
                        point4 = point2;
                    }
                    point3 = this.getLowerPoint(point3);
                    point4 = this.getHigherPoint(point4);
                    if (point3.x == point4.x) {
                        if (this.decideRowAddHV()) {
                            if (point3.y > 0) {
                                point3 = new Point(point3.x, point3.y - 1);
                            }
                            if (point4.y < this.m_fieldWidth - 1) {
                                point4 = new Point(point4.x, point4.y + 1);
                            }
                            for (n2 = point3.y; n2 <= point4.y; ++n2) {
                                point2 = new Point(point3.x, n2);
                                boolean bl4 = this.addRowShotPoint(point2);
                                bl3 = bl3 || bl4;
                            }
                        }
                    } else if (point3.y == point4.y) {
                        if (this.decideRowAddHV()) {
                            if (point3.x > 0) {
                                point3 = new Point(point3.x - 1, point3.y);
                            }
                            if (point4.x < this.m_fieldWidth - 1) {
                                point4 = new Point(point4.x + 1, point4.y);
                            }
                            for (n2 = point3.x; n2 <= point4.x; ++n2) {
                                point2 = new Point(n2, point3.y);
                                boolean bl5 = this.addRowShotPoint(point2);
                                bl3 = bl3 || bl5;
                            }
                        }
                    } else if (point3.y - point4.y == point3.x - point4.x) {
                        if (this.decideRowAddD()) {
                            if (point3.x > 0 && point3.y > 0) {
                                point3 = new Point(point3.x - 1, point3.y - 1);
                            }
                            if (point4.x < this.m_fieldWidth - 1 && point4.y < this.m_fieldWidth - 1) {
                                point4 = new Point(point4.x + 1, point4.y + 1);
                            }
                            int n3 = 0;
                            for (n2 = point3.x; n2 <= point4.x; ++n2) {
                                point2 = new Point(n2, point3.y + n3);
                                boolean bl6 = this.addRowShotPoint(point2);
                                bl3 = bl3 || bl6;
                                ++n3;
                            }
                        }
                    } else if (point3.x + point3.y == point4.x + point4.y && this.decideRowAddD()) {
                        if (point3.x > 0 && point3.y < this.m_fieldWidth - 1) {
                            point3 = new Point(point3.x - 1, point3.y + 1);
                        }
                        if (point4.x < this.m_fieldWidth - 1 && point4.y > 0) {
                            point4 = new Point(point4.x + 1, point4.y - 1);
                        }
                        int n4 = 0;
                        for (n2 = point3.x; n2 <= point4.x; ++n2) {
                            point2 = new Point(n2, point3.y - n4);
                            boolean bl7 = this.addRowShotPoint(point2);
                            bl3 = bl3 || bl7;
                            ++n4;
                        }
                    }
                    if (!bl3) {
                        this.applyFiringSolutionLogic("2");
                    }
                }
            }
        } else if (!bl2) {
            if (this.m_hitPoints.size() >= 3) {
                this.m_firingSolutions.clear();
            }
            this.applyFiringSolutionLogic("3");
        }
    }

    public int getShotsLeftPercent() {
        return (int)Math.round((double)this.m_totalShotPoints.size() / (double)(this.m_fieldWidth * this.m_fieldWidth) * 100.0);
    }

    private boolean decideRowAddHV() {
        boolean bl = false;
        if (this.m_hitPoints.size() < 3 && (this.m_plEnemyScore.hasActiveShips(2) || this.m_plEnemyScore.hasActiveShips(3) || this.m_plEnemyScore.hasActiveShips(4) || this.m_plEnemyScore.hasActiveShips(5) || this.m_plEnemyScore.hasActiveShips(6)) || this.m_hitPoints.size() <= 4 && (this.m_plEnemyScore.hasActiveShips(4) || this.m_plEnemyScore.hasActiveShips(6)) || this.m_hitPoints.size() == 5 && this.m_plEnemyScore.hasActiveShips(6)) {
            bl = true;
        }
        return bl;
    }

    private boolean decideRowAddD() {
        boolean bl = false;
        if (this.m_hitPoints.size() < 3 && (this.m_plEnemyScore.hasActiveShips(2) || this.m_plEnemyScore.hasActiveShips(4) || this.m_plEnemyScore.hasActiveShips(6)) || this.m_hitPoints.size() <= 4 && (this.m_plEnemyScore.hasActiveShips(4) || this.m_plEnemyScore.hasActiveShips(6)) || this.m_hitPoints.size() == 5 && this.m_plEnemyScore.hasActiveShips(6)) {
            bl = true;
        }
        return bl;
    }

    private void applyFiringSolutionLogic(String string) {
        if (this.m_hitPoints.size() > 1 && this.m_hitPoints.size() <= 3) {
            if (this.m_plEnemyScore.hasActiveShips(3)) {
                this.printDebug("Looking for special ships (" + string + "): Submarine");
                this.manageFiringSolutions(3);
            } else {
                this.printDebug("Looking for special ships (" + string + "-): Battleship");
                this.manageFiringSolutions(5);
            }
        }
        if (this.m_rowShotPoints.size() == 0 && this.m_hitPoints.size() >= 3) {
            this.printDebug("Looking for special ships (" + string + "): Battleship");
            this.manageFiringSolutions(5);
        }
    }

    private void manageFiringSolutions(int n) {
        if (this.m_firingSolutions.size() > 0) {
            this.getNextFiringSolution();
        } else {
            this.calculateFiringSolutions(n);
            if (this.m_firingSolutions.size() > 0) {
                this.getNextFiringSolution();
            }
        }
    }

    private void getNextFiringSolution() {
        this.m_rowShotPoints.clear();
        BotShot botShot = this.m_firingSolutions.remove(0);
        ArrayList<Point> arrayList = botShot.getFiringSolution();
        this.m_lastFiringSolution = arrayList;
        for (int i = 0; i < arrayList.size(); ++i) {
            Point point = arrayList.get(i);
            this.addRowShotPoint(point);
        }
    }

    private void calculateFiringSolutions(int n) {
        int n2;
        int n3;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        BattleShip battleShip = this.m_plTestShips.getShipPattern(n);
        if (n == 3) {
            n3 = 1;
            n2 = 4;
        } else {
            n3 = 2;
            n2 = 2;
        }
        for (int i = 0; i < this.m_hitPoints.size(); ++i) {
            Point point = this.m_hitPoints.get(i);
            this.fillNextShotPoints(point, arrayList, n3);
            for (int j = 0; j < arrayList.size(); ++j) {
                point = arrayList.get(j);
                battleShip.setPosition(point.x, point.y);
                for (int k = 1; k <= n2; ++k) {
                    int n4;
                    battleShip.setDirection(k);
                    ArrayList<Point> arrayList2 = battleShip.getPossibleHitpoints();
                    boolean bl = true;
                    for (n4 = 0; n4 < this.m_hitPoints.size(); ++n4) {
                        point = this.m_hitPoints.get(n4);
                        if (!arrayList2.contains(point)) {
                            bl = false;
                            break;
                        }
                        arrayList2.remove(point);
                    }
                    if (!bl) continue;
                    for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                        if (this.containsShotPoint(arrayList2.get(n4))) continue;
                        bl = false;
                        break;
                    }
                    if (!bl || this.containsFiringSolution(arrayList2)) continue;
                    boolean bl2 = false;
                    for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                        if (!this.checkSurrHits(arrayList2.get(n4), 1)) continue;
                        bl2 = true;
                        break;
                    }
                    int n5 = !bl2 ? 1 : 2;
                    BotShot botShot = new BotShot(n5, arrayList2);
                    this.m_firingSolutions.add(botShot);
                    this.printDebug("Added firing solution: " + botShot.toString() + " - direction: " + k + " - position: " + point.toString() + " - current hitpoints: " + this.m_hitPoints.toString());
                }
            }
            arrayList.clear();
        }
        Collections.sort(this.m_firingSolutions, BotShot.PriorityAsc);
    }

    private boolean containsFiringSolution(ArrayList<Point> arrayList) {
        boolean bl = false;
        for (int i = 0; i < this.m_firingSolutions.size(); ++i) {
            BotShot botShot = this.m_firingSolutions.get(i);
            if (!arrayList.equals(botShot.getFiringSolution())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Point getFiringPatternShotPoint() {
        Point point;
        int n;
        int n2 = 0;
        int n3 = 0;
        ArrayList<BotShot> arrayList = new ArrayList<BotShot>();
        ArrayList<Point> arrayList2 = new ArrayList<Point>();
        int n4 = 1;
        Point point2 = null;
        if (this.m_plEnemyScore.hasActiveShips(5)) {
            n3 = 5;
        } else if (this.m_plEnemyScore.hasActiveShips(4)) {
            n3 = 4;
        } else if (this.m_plEnemyScore.hasActiveShips(3)) {
            n3 = 3;
        } else if (this.m_plEnemyScore.hasActiveShips(2)) {
            n3 = 2;
        } else if (this.m_plEnemyScore.hasActiveShips(1)) {
            n3 = 1;
        }
        if (n3 == 0) {
            return point2;
        }
        int n5 = n3 == 5 ? 2 : 4;
        BattleShip battleShip = this.m_plTestShips.getShipPattern(n3);
        for (n = 0; n < this.m_fieldWidth * this.m_fieldWidth; ++n) {
            n2 = (int)Math.round(Math.random() * (double)(this.m_totalShotPoints.size() - 1));
            point = this.m_totalShotPoints.get(n2);
            this.findSurrShots(point, arrayList, n4, 0.4);
        }
        Collections.sort(arrayList, BotShot.PriorityAsc);
        for (n = 0; n < this.m_fieldWidth * this.m_fieldWidth / 2; ++n) {
            point = ((BotShot)arrayList.get(n)).getShot();
            this.fillNextShotPoints(point, arrayList2, n4);
            for (int i = 0; i < arrayList2.size(); ++i) {
                point = arrayList2.get(i);
                battleShip.setPosition(point.x, point.y);
                for (int j = 1; j <= n5; ++j) {
                    int n6;
                    battleShip.setDirection(j);
                    ArrayList<Point> arrayList3 = battleShip.getPossibleHitpoints();
                    boolean bl = true;
                    for (n6 = 0; n6 < arrayList3.size(); ++n6) {
                        point = arrayList3.get(n6);
                        if (this.m_totalShotPoints.contains(point)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    boolean bl2 = false;
                    for (n6 = 0; n6 < arrayList3.size(); ++n6) {
                        point = arrayList3.get(n6);
                        if (!this.checkSurrHits(point, 1) && (this.m_seekEdges || point.x != 0 && point.y != 0 && point.x != this.m_fieldWidth - 1 && point.y != this.m_fieldWidth - 1)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    switch (n3) {
                        case 1: {
                            n2 = (int)Math.round(Math.random() * (double)(arrayList3.size() - 1));
                            break;
                        }
                        case 2: {
                            n2 = 1;
                            break;
                        }
                        case 3: {
                            switch (j) {
                                case 1: 
                                case 2: {
                                    n2 = 1;
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    n2 = 2;
                                }
                            }
                            break;
                        }
                        case 4: 
                        case 6: {
                            n2 = 2;
                            break;
                        }
                        case 5: {
                            n2 = j == 1 ? 3 : 4;
                        }
                    }
                    point2 = arrayList3.get(n2);
                    this.printDebug("Firing Pattern Point: " + point2.toString() + " - shipType: " + n3 + " - found after: " + n * i + " - index: " + n2 + " - direction: " + j + " - pattern: " + arrayList3.toString());
                    return point2;
                }
            }
            arrayList2.clear();
        }
        return point2;
    }

    private boolean addRowShotPoint(Point point) {
        boolean bl = false;
        if (this.containsShotPoint(point)) {
            this.m_rowShotPoints.add(point);
            bl = true;
        }
        return bl;
    }

    private Point getHigherPoint(Point point) {
        for (int i = 0; i < this.m_hitPoints.size(); ++i) {
            Point point2 = this.m_hitPoints.get(i);
            if (!(point2.y == point.y && point2.x > point.x || point2.x == point.x && point2.y > point.y || point2.y - point.y == point2.x - point.x && point2.x > point.x) && (point2.x + point2.y != point.x + point.y || point2.x <= point.x)) continue;
            point = point2;
        }
        return point;
    }

    private Point getLowerPoint(Point point) {
        for (int i = 0; i < this.m_hitPoints.size(); ++i) {
            Point point2 = this.m_hitPoints.get(i);
            if (!(point2.y == point.y && point2.x < point.x || point2.x == point.x && point2.y < point.y || point2.y - point.y == point2.x - point.x && point2.x < point.x) && (point2.x + point2.y != point.x + point.y || point2.x >= point.x)) continue;
            point = point2;
        }
        return point;
    }

    private void fillTotalShotPoints() {
        for (int i = 0; i < this.m_fieldWidth; ++i) {
            for (int j = 0; j < this.m_fieldWidth; ++j) {
                this.m_totalShotPoints.add(new Point(j, i));
            }
        }
    }

    private Point getNextShotPoint() {
        Point point = null;
        ArrayList<BotShot> arrayList = new ArrayList<BotShot>();
        int n = this.getShotsLeftPercent();
        int n2 = this.m_plEnemyScore.getActiveShipsFieldPercent();
        int n3 = n > 89 ? 2 : 1;
        this.printDebug("Ship Percentage Left: " + n2);
        if (n < 60 && n2 > 20 || n < 50) {
            this.m_seekEdges = true;
        }
        if (n < 66 && (point = this.getFiringPatternShotPoint()) == null) {
            this.m_seekEdges = true;
        }
        if (point == null) {
            double d = Math.random();
            for (int i = 0; i < 100; ++i) {
                int n4 = (int)Math.round(Math.random() * (double)(this.m_totalShotPoints.size() - 1));
                point = this.m_totalShotPoints.get(n4);
                if (n > 63 || n < 53) {
                    this.findSurrShots(point, arrayList, n3, d);
                    continue;
                }
                this.seekShotCrossing(point, arrayList, d);
            }
            if (n > 63 || n < 53) {
                Collections.sort(arrayList, BotShot.PriorityAsc);
            } else {
                Collections.sort(arrayList, BotShot.PriorityDesc);
            }
            BotShot botShot = (BotShot)arrayList.get(0);
            point = botShot.getShot();
        }
        this.printDebug("Chosen Shot: " + point.toString() + " - percent: " + n);
        this.m_totalShotPoints.remove(point);
        return point;
    }

    private Point getSurrShotPoint() {
        BotShot botShot;
        ArrayList<Object> arrayList = new ArrayList();
        for (int i = 0; i < this.m_surrShotPoints.size(); ++i) {
            botShot = this.m_surrShotPoints.get(i);
            if (botShot.getPriority() != 1) continue;
            arrayList.add(botShot);
        }
        if (arrayList.size() == 0) {
            arrayList = this.m_surrShotPoints;
        }
        int n = (int)Math.round(Math.random() * (double)(arrayList.size() - 1));
        botShot = (BotShot)arrayList.get(n);
        this.m_surrShotPoints.remove(botShot);
        return botShot.getShot();
    }

    private boolean containsShotPoint(Point point) {
        return this.m_totalShotPoints.contains(point);
    }

    private void removeSurrShotPoint(Point point) {
        for (int i = 0; i < this.m_surrShotPoints.size(); ++i) {
            BotShot botShot = this.m_surrShotPoints.get(i);
            if (!point.equals(botShot.getShot())) continue;
            this.m_surrShotPoints.remove(i);
            break;
        }
    }

    private boolean containsSurrShotPoint(Point point) {
        boolean bl = false;
        for (int i = 0; i < this.m_surrShotPoints.size(); ++i) {
            BotShot botShot = this.m_surrShotPoints.get(i);
            if (!point.equals(botShot.getShot())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void fillSurrShotPoints(Point point, ArrayList<BotShot> arrayList) {
        int n = 1;
        SeekBounds seekBounds = new SeekBounds(point, n, this.m_fieldWidth);
        for (int i = seekBounds.getStartX(); i <= seekBounds.getEndX(); ++i) {
            for (int j = seekBounds.getStartY(); j <= seekBounds.getEndY(); ++j) {
                Point point2 = new Point(i, j);
                if (!this.containsShotPoint(point2) || this.containsSurrShotPoint(point2)) continue;
                int n2 = !this.checkSurrHits(point2, 1) ? 1 : 2;
                BotShot botShot = new BotShot(n2, point2);
                arrayList.add(botShot);
            }
        }
    }

    private void fillNextShotPoints(Point point, ArrayList<Point> arrayList, int n) {
        SeekBounds seekBounds = new SeekBounds(point, n, this.m_fieldWidth);
        arrayList.add(point);
        for (int i = seekBounds.getStartX(); i <= seekBounds.getEndX(); ++i) {
            for (int j = seekBounds.getStartY(); j <= seekBounds.getEndY(); ++j) {
                Point point2 = new Point(i, j);
                arrayList.add(point2);
            }
        }
    }

    private void findSurrShots(Point point, ArrayList<BotShot> arrayList, int n, double d) {
        int n2 = 1;
        boolean bl = false;
        SeekBounds seekBounds = new SeekBounds(point, n, this.m_fieldWidth);
        for (int i = seekBounds.getStartX(); i <= seekBounds.getEndX(); ++i) {
            for (int j = seekBounds.getStartY(); j <= seekBounds.getEndY(); ++j) {
                Point point2 = new Point(i, j);
                if (!this.containsShotPoint(point2)) {
                    ++n2;
                }
                if (bl || !this.m_totalHitPoints.contains(point2)) continue;
                n2 += 8;
                bl = true;
            }
        }
        if (!this.m_seekEdges && d > 0.4 && (point.x == 0 || point.y == 0 || point.x == this.m_fieldWidth - 1 || point.y == this.m_fieldWidth - 1)) {
            n2 += 4;
        }
        arrayList.add(new BotShot(n2, point));
    }

    private boolean checkSurrHits(Point point, int n) {
        boolean bl = false;
        SeekBounds seekBounds = new SeekBounds(point, n, this.m_fieldWidth);
        block0: for (int i = seekBounds.getStartX(); i <= seekBounds.getEndX(); ++i) {
            for (int j = seekBounds.getStartY(); j <= seekBounds.getEndY(); ++j) {
                Point point2 = new Point(i, j);
                if (!this.m_totalHitPoints.contains(point2) || this.m_hitPoints.contains(point2)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    private void seekShotCrossing(Point point, ArrayList<BotShot> arrayList, double d) {
        Point point2;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 1;
        for (n = point.x - 1; n >= 0 && this.containsShotPoint(point2 = new Point(n, point.y)); --n) {
            ++n2;
        }
        n6 += n2 - 1;
        for (n = point.x + 1; n < this.m_fieldWidth && this.containsShotPoint(point2 = new Point(n, point.y)); ++n) {
            ++n3;
        }
        n6 += n3 - 1;
        int n7 = n2 + n3 + 1 - Math.abs(n2 - n3);
        for (n = point.y - 1; n >= 0 && this.containsShotPoint(point2 = new Point(point.x, n)); --n) {
            ++n4;
        }
        n6 += n4 - 1;
        for (n = point.y + 1; n < this.m_fieldWidth && this.containsShotPoint(point2 = new Point(point.x, n)); ++n) {
            ++n5;
        }
        n6 += n5 - 1;
        int n8 = n4 + n5 + 1 - Math.abs(n2 - n3);
        if (this.checkSurrHits(point, 1)) {
            n6 = 1;
        }
        arrayList.add(new BotShot(n6, point));
    }

    private void printDebug(String string) {
        if (this.m_debug) {
            System.out.println(string);
        }
    }

    private class SeekBounds {
        private int m_startX;
        private int m_startY;
        private int m_endX;
        private int m_endY;

        public SeekBounds(Point point, int n, int n2) {
            this.m_startX = point.x - n < 0 ? 0 : point.x - n;
            this.m_endX = point.x + n > n2 - 1 ? n2 - 1 : point.x + n;
            this.m_startY = point.y - n < 0 ? 0 : point.y - n;
            this.m_endY = point.y + n > n2 - 1 ? n2 - 1 : point.y + n;
        }

        public int getStartX() {
            return this.m_startX;
        }

        public int getStartY() {
            return this.m_startY;
        }

        public int getEndX() {
            return this.m_endX;
        }

        public int getEndY() {
            return this.m_endY;
        }
    }
}

