/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class BattleShipsConnection
extends Thread {
    private Socket m_oSckClient;
    private ServerSocket m_oSckServer;
    private InputStream m_oInputStream;
    private OutputStream m_oOutputStream;
    private boolean m_bIsClient;
    private boolean m_bRunning;
    private String m_sHost;
    private int m_iPort;
    private BattleShipsConnectionListener m_oStlOwner;
    private String m_sObjectName;
    private String m_sMessageQualifier;
    private int m_iPingCounter;
    private int m_iIsAliveCounter;
    private String m_sLastMessage;
    private String m_sLastData;
    private boolean m_bSentData;
    private int m_iConfirmationCounter;
    private int m_iResendCounter;
    private String m_sSocketIdentifier;
    private String m_playerName;
    private final boolean DEBUG = false;
    private final int CHECK_INTERVAL = 300;
    private final int CONFIRMATION_INTERVAL = 300;
    private final int MAX_RESEND_COUNT = 3;

    public BattleShipsConnection(BattleShipsConnectionListener battleShipsConnectionListener) {
        this(battleShipsConnectionListener, null, "");
    }

    public BattleShipsConnection(BattleShipsConnectionListener battleShipsConnectionListener, Socket socket, String string) {
        this.m_oStlOwner = battleShipsConnectionListener;
        this.m_oSckClient = socket;
        this.m_sSocketIdentifier = string;
        this.m_sMessageQualifier = "msg";
        this.setPriority(10);
        this.m_playerName = this.getRandomPlayerName();
    }

    public void start(int n) {
        this.m_bIsClient = false;
        this.m_iPort = n;
        this.start();
    }

    public void start(String string, int n) {
        this.m_bIsClient = true;
        this.m_sHost = string;
        this.m_iPort = n;
        this.start();
    }

    @Override
    public void start() {
        if (!this.m_bRunning) {
            this.m_bRunning = true;
            super.start();
        }
    }

    @Override
    public void interrupt() {
        if (this.m_bRunning) {
            super.interrupt();
            this.m_bRunning = false;
            this.closeSockets();
        }
    }

    @Override
    public void run() {
        String string = "";
        String string2 = "";
        String string3 = "";
        Integer n = new Integer(0);
        int n2 = 0;
        this.m_iPingCounter = 0;
        this.m_iIsAliveCounter = 0;
        this.m_iConfirmationCounter = 0;
        this.m_iResendCounter = 0;
        if (this.m_oSckClient == null) {
            if (this.m_bIsClient) {
                try {
                    this.m_oSckClient = new Socket(InetAddress.getByName(this.m_sHost), this.m_iPort);
                }
                catch (UnknownHostException unknownHostException) {
                    this.setError("UnknownHost", unknownHostException.getMessage());
                }
                catch (Exception exception) {
                    this.setError("General", exception.getMessage());
                }
            } else {
                try {
                    this.m_oSckServer = new ServerSocket(this.m_iPort);
                    this.m_oSckClient = this.m_oSckServer.accept();
                }
                catch (IOException iOException) {
                    this.setError("ServerStart", iOException.getMessage());
                }
            }
        }
        if (this.m_bRunning) {
            try {
                this.m_oInputStream = this.m_oSckClient.getInputStream();
                this.m_oOutputStream = this.m_oSckClient.getOutputStream();
                this.setMessage("status", "Connected");
            }
            catch (Exception exception) {
                this.setError("General", exception.getMessage());
            }
        }
        while (this.m_bRunning) {
            n2 = 0;
            while (this.m_bRunning && n2 == 0) {
                try {
                    n2 = this.m_oInputStream.available();
                    ++this.m_iIsAliveCounter;
                    ++this.m_iPingCounter;
                    if (this.m_iPingCounter == 300) {
                        this.sendMessage("ping", "");
                    }
                    if (this.m_iIsAliveCounter > 600) {
                        this.setMessage("disconnected", "");
                        this.m_iIsAliveCounter = 0;
                    }
                    if (this.m_bSentData) {
                        ++this.m_iConfirmationCounter;
                    }
                    if (this.m_iConfirmationCounter == 300) {
                        this.sendMessage(this.m_sLastMessage, this.m_sLastData);
                        this.m_iConfirmationCounter = 0;
                        ++this.m_iResendCounter;
                    }
                    if (this.m_iResendCounter == 3) {
                        this.setMessage("disconnected", "");
                    }
                    try {
                        BattleShipsConnection.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                catch (Exception exception) {
                    this.setError("General", exception.getMessage());
                }
            }
            if (!this.m_bRunning) continue;
            byte[] byArray = new byte[n2];
            try {
                this.m_oInputStream.read(byArray);
            }
            catch (Exception exception) {
                this.setError("General", exception.getMessage());
            }
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = new String(byArray);
            }
            if (this.m_sMessageQualifier.equals("")) {
                this.setMessage("", string);
            } else {
                int n3 = this.m_sMessageQualifier.length() + 2;
                int n4 = 0;
                int n5 = 0;
                String string4 = "";
                for (int i = 0; n4 >= 0 && i < 64; ++i) {
                    n4 = string.indexOf("<" + this.m_sMessageQualifier + ">", n4);
                    if (n4 <= -1 || n4 >= (n5 = string.indexOf("</" + this.m_sMessageQualifier + ">", n4)) || (string2 = (string4 = string.substring(n4 += n3, n5)).substring(1, string4.indexOf(">", 0))).equals("ping")) continue;
                    int n6 = string4.indexOf(">");
                    string3 = string4.substring(n6 + 1, string4.indexOf("<", n6));
                    if (string2.equals("confirmation")) {
                        if (!string3.equals(this.m_sLastMessage)) continue;
                        this.m_bSentData = false;
                        this.m_iConfirmationCounter = 0;
                        this.m_iResendCounter = 0;
                        continue;
                    }
                    this.setMessage(string2, string3);
                    if (string2.equals("disconnected")) continue;
                    this.sendMessage("confirmation", string2);
                }
            }
            this.m_iIsAliveCounter = 0;
        }
    }

    public void setMessageQualifier(String string) {
        this.m_sMessageQualifier = string;
    }

    public void sendMessage(String string, String string2) {
        byte[] byArray;
        if (this.m_oOutputStream == null) {
            return;
        }
        this.m_iPingCounter = 0;
        if (!(string.equals("ping") || string.equals("confirmation") || string.equals("disconnected"))) {
            this.m_bSentData = true;
            this.m_sLastMessage = string;
            this.m_sLastData = string2;
        }
        if (string.equals("") || this.m_sMessageQualifier.equals("")) {
            string = string2;
        } else {
            string2 = StringTool.replace(string2, "<", "&lt;");
            string2 = StringTool.replace(string2, ">", "&gt;");
            string = "<" + this.m_sMessageQualifier + "><" + string + ">" + string2 + "</" + string + "></" + this.m_sMessageQualifier + ">";
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        try {
            this.m_oOutputStream.write(byArray);
            this.m_oOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void send(String string) {
        this.sendMessage("", string);
    }

    public void setPlayerName(String string) {
        this.m_playerName = string;
    }

    public String getPlayerName() {
        return this.m_playerName;
    }

    private synchronized void setMessage(String string, String string2) {
        string2 = StringTool.replace(string2, "&lt;", "<");
        string2 = StringTool.replace(string2, "&gt;", ">");
        if (this.m_sSocketIdentifier.equals("")) {
            this.m_oStlOwner.socketDataArrived(string, string2);
        } else {
            this.m_oStlOwner.socketDataArrived(string, string2, this.m_sSocketIdentifier);
        }
    }

    private void setError(String string, String string2) {
        if (this.m_sSocketIdentifier.equals("")) {
            this.m_oStlOwner.socketError(string, string2);
        } else {
            this.m_oStlOwner.socketError(string, string2, this.m_sSocketIdentifier);
        }
    }

    private void closeSockets() {
        this.sendMessage("disconnected", "reset");
        if (this.m_oSckClient != null) {
            try {
                if (this.m_oInputStream != null) {
                    this.m_oInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.m_oOutputStream != null) {
                    this.m_oOutputStream.flush();
                    this.m_oOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.m_oSckClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.m_bIsClient && this.m_oSckServer != null) {
            try {
                this.m_oSckServer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getRandomPlayerName() {
        return "Anon" + Math.round(Math.random() * 1.0E8);
    }
}

