/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;

public class BattleShipsField
extends Container {
    private int m_iCellWidth;
    private int m_iFieldWidth;
    private CopyOnWriteArrayList<Point> m_alShots;
    private ArrayList<BattleShip> m_alBattleShips;
    private boolean m_bEnemyField;
    private boolean m_bPlaying;
    private int m_iSunkCount;
    private int[] m_iShipTypeCount;
    private int m_iMaxShipType;
    private int m_iFieldType;
    private Color m_oColShip;
    private Color m_oColShipSunk;
    private Color m_oColShipHitMark;
    private Color m_oColShipHighlight;
    private Color m_oColShotMark;
    private Color m_oColLastShotMark;
    private Image m_oImgShipSegment;
    private Image m_oImgShipSegmentSunk;
    private Cursor m_bShootCursor;
    private BattleShip[] m_bsShipPattern;
    private int[] m_activeShips;
    private boolean m_debug;
    public static final int FIELD_TYPE_ME = 1;
    public static final int FIELD_TYPE_ENEMY = 2;
    public static final int FIELD_TYPE_SCORE = 3;

    public BattleShipsField(int n, int n2) {
        this.m_iMaxShipType = n;
        this.m_iFieldType = n2;
        this.m_bEnemyField = this.m_iFieldType == 2;
        this.m_bPlaying = false;
        this.m_iSunkCount = 0;
        this.m_debug = false;
        this.m_alShots = new CopyOnWriteArrayList();
        this.m_alBattleShips = new ArrayList();
        this.m_iShipTypeCount = new int[this.m_iMaxShipType];
        this.m_activeShips = new int[this.m_iMaxShipType];
        this.addMouseListener(new TheMouseAdapter(this, "i"));
    }

    public void init(int n, int n2) {
        this.m_iCellWidth = n;
        this.m_iFieldWidth = n2;
        int n3 = this.m_iCellWidth * this.m_iFieldWidth + 1;
        this.setSize(n3, n3);
    }

    private void paintShot(Graphics graphics, Point point, Color color) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(color);
        graphics.fillRect(point.x * this.m_iCellWidth + 1, point.y * this.m_iCellWidth + 1, this.m_iCellWidth - 1, this.m_iCellWidth - 1);
        if (this.m_debug) {
            if (point.x == 0) {
                graphics.setColor(this.getForeground());
                graphics.drawString(String.valueOf(point.y), 2, point.y * this.m_iCellWidth + Math.round(this.m_iCellWidth / 2) + 5);
            }
            if (point.y == 0 && point.x > 0) {
                graphics.setColor(this.getForeground());
                graphics.drawString(String.valueOf(point.x), point.x * this.m_iCellWidth + Math.round(this.m_iCellWidth / 2) - 6, this.m_iCellWidth - 3);
            }
        }
    }

    public void setColorShip(Color color) {
        this.m_oColShip = color;
    }

    public void setColorShipSunk(Color color) {
        this.m_oColShipSunk = color;
    }

    public void setColorShipHitMark(Color color) {
        this.m_oColShipHitMark = color;
    }

    public void setColorShipHighlight(Color color) {
        this.m_oColShipHighlight = color;
    }

    public void setColorShotMark(Color color) {
        this.m_oColShotMark = color;
    }

    public void setColorLastShotMark(Color color) {
        this.m_oColLastShotMark = color;
    }

    public void setImageShipSegment(Image image) {
        this.m_oImgShipSegment = image;
    }

    public void setImageShipSegmentSunk(Image image) {
        this.m_oImgShipSegmentSunk = image;
    }

    public void setShootCursor(Cursor cursor) {
        this.m_bShootCursor = cursor;
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        Point point = null;
        Color color = null;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
        super.paint(graphics);
        graphics.setColor(this.getForeground());
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        if (this.m_iFieldType != 3) {
            int n;
            int n2 = this.m_iFieldWidth - 1;
            int n3 = this.getBounds().height;
            for (n = 1; n <= n2; ++n) {
                graphics.drawLine(n * this.m_iCellWidth, 0, n * this.m_iCellWidth, n3 - 1);
            }
            n3 = this.getBounds().width;
            for (n = 1; n <= n2; ++n) {
                graphics.drawLine(0, n * this.m_iCellWidth, n3 - 1, n * this.m_iCellWidth);
            }
            ListIterator<Point> listIterator = this.m_alShots.listIterator();
            while (listIterator.hasNext()) {
                point = listIterator.next();
                color = listIterator.hasNext() ? this.m_oColShotMark : this.m_oColLastShotMark;
                this.paintShot(graphics, point, color);
            }
            if (this.m_debug) {
                graphics.setColor(this.getForeground());
                for (n = 1; n <= n2; ++n) {
                    graphics.drawString(String.valueOf(n - 1), 2, n * this.m_iCellWidth - Math.round(this.m_iCellWidth / 2) + 5);
                }
                graphics.drawString(String.valueOf(n - 1), 2, n * this.m_iCellWidth - Math.round(this.m_iCellWidth / 2) + 5);
                n3 = this.getBounds().width;
                for (n = 1; n <= n2; ++n) {
                    if (n <= 1) continue;
                    graphics.drawString(String.valueOf(n - 1), n * this.m_iCellWidth - Math.round(this.m_iCellWidth / 2) - 6, this.m_iCellWidth - 3);
                }
                graphics.drawString(String.valueOf(n - 1), n * this.m_iCellWidth - Math.round(this.m_iCellWidth / 2) - 6, this.m_iCellWidth - 3);
            }
        }
    }

    private BattleShip addShip(BattleShip battleShip) {
        this.m_alBattleShips.add(battleShip);
        return (BattleShip)this.add(battleShip);
    }

    public void addShipsAndInfo() {
        BattleShip battleShip = null;
        TextDisplayPanel textDisplayPanel = null;
        BattleShipsPanel battleShipsPanel = this.getBattleShipsPanel();
        int n = this.m_iCellWidth < 11 ? 11 : this.m_iCellWidth;
        Font font = new Font("SansSerif", 1, n);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        String string = "";
        Dimension dimension = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 1; i <= this.m_iMaxShipType; ++i) {
            int n8 = this.m_iShipTypeCount[i - 1];
            if (n8 <= 0) continue;
            switch (i) {
                case 3: 
                case 5: {
                    n6 = 4;
                    break;
                }
                default: {
                    n6 = 3;
                }
            }
            battleShip = this.addShip(new BattleShip(this.m_iCellWidth, i, false));
            battleShip.setForeground(this.m_oColShip);
            battleShip.setColorSunk(this.m_oColShipSunk);
            battleShip.setImageSegment(this.m_oImgShipSegment);
            battleShip.setImageSegmentSunk(this.m_oImgShipSegmentSunk);
            battleShip.setColorHitMark(this.m_oColShipHitMark);
            battleShip.setColorHighlight(this.m_oColShipHighlight);
            battleShip.setColorShotMark(this.m_oColShotMark);
            battleShip.setDirection(n6);
            battleShip.setPosition(1, n7 + 1);
            battleShip.setLocked(true);
            string = battleShipsPanel.getString("BattleShipType" + i);
            textDisplayPanel = (TextDisplayPanel)this.add(new TextDisplayPanel());
            textDisplayPanel.setVisible(false);
            textDisplayPanel.setFont(font);
            textDisplayPanel.setText(string, 1);
            n2 = fontMetrics.stringWidth(string) + 10;
            textDisplayPanel.setLocation((int)Math.round((double)this.m_iCellWidth * 7.5), n7 * this.m_iCellWidth + this.m_iCellWidth - 3);
            n7 += Math.round(battleShip.getSize().height / this.m_iCellWidth) + 1;
            dimension = battleShip.getSize();
            if (n3 < dimension.width) {
                n3 = dimension.width;
            }
            if (n4 < n2) {
                n4 = n2;
            }
            ++n5;
        }
        if (n3 < Math.round(this.m_iCellWidth * 6)) {
            n3 = Math.round(this.m_iCellWidth * 6);
        }
        n2 = n3 + n4 + (int)Math.round((double)this.m_iCellWidth * 2.5);
        this.setBounds(Math.round((battleShipsPanel.getSize().width - n2) / 2), this.getLocation().y, n2, n7 * this.m_iCellWidth + this.m_iCellWidth);
    }

    @Override
    public void setVisible(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setVisible(bl);
        }
        super.setVisible(bl);
    }

    public boolean addAllMyShips() {
        BattleShip battleShip = null;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        Cursor cursor = new Cursor(12);
        for (int i = 1; i <= this.m_iMaxShipType; ++i) {
            int n3 = this.m_iShipTypeCount[i - 1];
            if (n3 <= 0) continue;
            for (int j = 1; j <= n3; ++j) {
                battleShip = this.addShip(new BattleShip(this.m_iCellWidth, i, false));
                battleShip.setForeground(this.m_oColShip);
                battleShip.setColorSunk(this.m_oColShipSunk);
                battleShip.setImageSegment(this.m_oImgShipSegment);
                battleShip.setImageSegmentSunk(this.m_oImgShipSegmentSunk);
                battleShip.setColorHitMark(this.m_oColShipHitMark);
                battleShip.setColorHighlight(this.m_oColShipHighlight);
                battleShip.setColorShotMark(this.m_oColShotMark);
                battleShip.setPosition(n * 3 + 1, 1);
                n2 += battleShip.getMaxShipArea();
                if (this.m_iFieldType == 3) {
                    battleShip.setLocked(true);
                } else {
                    battleShip.setCursor(cursor);
                }
                ++n;
            }
        }
        if (this.m_iFieldType != 3) {
            if ((double)n2 > Math.pow(this.m_iFieldWidth * this.m_iCellWidth, 2.0)) {
                bl = false;
            } else {
                this.setShipsRandomPosition(true, true);
            }
        }
        return bl;
    }

    public void addAllEnemyShips(String string) {
        String string2 = "";
        BattleShip battleShip = null;
        StringTokenizer stringTokenizer = null;
        if (this.getComponentCount() > 0) {
            return;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "|");
        while (stringTokenizer2.hasMoreTokens()) {
            string2 = stringTokenizer2.nextToken();
            stringTokenizer = new StringTokenizer(string2, ";");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            battleShip = this.addShip(new BattleShip(this.m_iCellWidth, n, true));
            battleShip.setForeground(this.m_oColShip);
            battleShip.setColorSunk(this.m_oColShipSunk);
            battleShip.setImageSegment(this.m_oImgShipSegment);
            battleShip.setImageSegmentSunk(this.m_oImgShipSegmentSunk);
            battleShip.setColorHitMark(this.m_oColShipHitMark);
            battleShip.setColorHighlight(this.m_oColShipHighlight);
            battleShip.setColorShotMark(this.m_oColShotMark);
            battleShip.setPosition(n3, n4);
            battleShip.setDirection(n2);
            battleShip.setLocked(true);
        }
    }

    public void addTestShips() {
        this.m_bsShipPattern = new BattleShip[this.m_iMaxShipType];
        BattleShip battleShip = this.addShip(new BattleShip(4, 1, true));
        battleShip.setPosition(1, 1);
        battleShip.setDirection(1);
        this.m_bsShipPattern[0] = battleShip;
        battleShip = this.addShip(new BattleShip(4, 2, true));
        battleShip.setPosition(3, 1);
        battleShip.setDirection(1);
        this.m_bsShipPattern[1] = battleShip;
        battleShip = this.addShip(new BattleShip(4, 3, true));
        battleShip.setPosition(5, 1);
        battleShip.setDirection(1);
        this.m_bsShipPattern[2] = battleShip;
        battleShip = this.addShip(new BattleShip(4, 4, true));
        battleShip.setPosition(8, 1);
        battleShip.setDirection(1);
        this.m_bsShipPattern[3] = battleShip;
        battleShip = this.addShip(new BattleShip(4, 5, true));
        battleShip.setPosition(10, 1);
        battleShip.setDirection(1);
        this.m_bsShipPattern[4] = battleShip;
    }

    public void setShipTypeCount(int n, int n2) {
        this.m_iShipTypeCount[n - 1] = n2;
        this.m_activeShips[n - 1] = n2;
    }

    public void setShipsRandomPosition() {
        int n = (int)Math.round(Math.random());
        boolean bl = n != 0;
        boolean bl2 = true;
        this.setShipsRandomPosition(bl, bl2);
    }

    public void setShipsRandomPosition(boolean bl, boolean bl2) {
        BattleShip battleShip = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.setAllBattleShipsVisible(false);
        do {
            ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
            while (listIterator.hasNext()) {
                battleShip = listIterator.next();
                battleShip.setDirection(1);
                battleShip.setPosition(n5 * 3 + 1, 1);
                ++n5;
            }
            listIterator = this.m_alBattleShips.listIterator();
            while (listIterator.hasNext()) {
                n5 = 0;
                battleShip = listIterator.next();
                while (true) {
                    int n7 = (int)Math.round(Math.random() * 3.0) + 1;
                    battleShip.setDirection(n7);
                    n3 = battleShip.getSize().width / this.m_iCellWidth;
                    n4 = battleShip.getSize().height / this.m_iCellWidth;
                    n = (int)Math.round(Math.random() * (double)(this.m_iFieldWidth - n3));
                    n2 = (int)Math.round(Math.random() * (double)(this.m_iFieldWidth - n4));
                    battleShip.setPosition(n, n2);
                    if (++n5 < 500 && (this.shipsIntersect(bl2) || !bl && (n == 0 || n > this.m_iFieldWidth - n3 - 1 || n2 == 0 || n2 > this.m_iFieldWidth - n4 - 1))) continue;
                    if (n5 == 501) {
                        bl = true;
                    }
                    if (n5 != 500) break;
                }
            }
        } while (n5 == 501 && ++n6 < 10);
        this.setAllBattleShipsVisible(true);
    }

    public void removeAllShips() {
        this.m_alBattleShips.clear();
        this.removeAll();
    }

    private boolean shipsIntersect(boolean bl) {
        boolean bl2 = false;
        Point point = this.getShipsIntersectionPoint(false, bl);
        if (point != null) {
            bl2 = true;
        }
        return bl2;
    }

    public Point getShipsIntersectionPoint(boolean bl, boolean bl2) {
        BattleShip battleShip = null;
        BattleShip battleShip2 = null;
        Point point = null;
        boolean bl3 = false;
        BattleShip[] battleShipArray = new BattleShip[this.m_alBattleShips.size()];
        BattleShip[] battleShipArray2 = battleShipArray = this.m_alBattleShips.toArray(battleShipArray);
        for (int i = 0; i < battleShipArray.length; ++i) {
            for (int j = 0; j < battleShipArray2.length; ++j) {
                if (battleShipArray[i].equals(battleShipArray2[j]) || !(battleShip = battleShipArray[i]).intersects(battleShip2 = battleShipArray2[j], bl2)) continue;
                bl3 = true;
                break;
            }
            if (bl3) break;
        }
        if (bl3) {
            if (bl) {
                this.remove(battleShip);
                this.add((Component)battleShip, 0);
                battleShip.setHighlight(true);
            }
            point = new Point(battleShip.getType(), battleShip2.getType());
        }
        return point;
    }

    public String getShipInfo() {
        Point point = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        BattleShip battleShip = null;
        ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
        Cursor cursor = new Cursor(0);
        while (listIterator.hasNext()) {
            if (bl) {
                stringBuffer.append("|");
            }
            battleShip = listIterator.next();
            battleShip.setLocked(true);
            battleShip.setHighlight(false);
            battleShip.setCursor(cursor);
            point = battleShip.getPosition();
            stringBuffer.append(battleShip.getType());
            stringBuffer.append(";");
            stringBuffer.append(battleShip.getDirection());
            stringBuffer.append(";");
            stringBuffer.append(point.x);
            stringBuffer.append(";");
            stringBuffer.append(point.y);
            bl = true;
        }
        return stringBuffer.toString();
    }

    public void sinkShip(int n) {
        BattleShip battleShip = null;
        ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
        while (listIterator.hasNext()) {
            battleShip = listIterator.next();
            if (battleShip.getType() != n || battleShip.getSunk()) continue;
            battleShip.setSunk();
            int n2 = n - 1;
            this.m_activeShips[n2] = this.m_activeShips[n2] - 1;
            return;
        }
    }

    public void showEnemyShips() {
        BattleShip battleShip = null;
        ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
        while (listIterator.hasNext()) {
            battleShip = listIterator.next();
            if (battleShip.getSunk()) continue;
            battleShip.setForceVisibility();
        }
    }

    public void passShot(boolean bl, Point point, boolean bl2, boolean bl3, int n, ArrayList<Point> arrayList) {
        boolean bl4 = false;
        if (bl3) {
            ++this.m_iSunkCount;
            if (this.m_iSunkCount == this.m_alBattleShips.size()) {
                bl4 = true;
            }
        }
        if (!bl2) {
            this.shoot(point);
        } else {
            this.getBattleShipsPanel().passShot(bl, point, bl2, bl3, n, bl4, arrayList);
        }
    }

    public boolean shoot(Point point) {
        BattleShip battleShip = null;
        ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
        while (listIterator.hasNext()) {
            battleShip = listIterator.next();
            if (!battleShip.shoot(point)) continue;
            return true;
        }
        this.addAndPaintShot(point);
        return false;
    }

    public boolean hasActiveShips(int n) {
        boolean bl = false;
        if (this.m_activeShips[n - 1] > 0) {
            bl = true;
        }
        return bl;
    }

    private BattleShipsPanel getBattleShipsPanel() {
        return (BattleShipsPanel)this.getParent().getParent();
    }

    public int getActiveShipsFieldPercent() {
        int n = 0;
        int n2 = 0;
        BattleShip battleShip = null;
        ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
        while (listIterator.hasNext()) {
            battleShip = listIterator.next();
            if (battleShip.getSunk()) {
                ++n2;
                continue;
            }
            ++n;
        }
        int n3 = (int)Math.round((double)n / (double)(n + n2) * 100.0);
        return n3;
    }

    private void addAndPaintShot(Point point) {
        if (!this.m_alShots.contains(point)) {
            Graphics graphics = this.getGraphics();
            this.paintShot(graphics, point, this.m_oColLastShotMark);
            if (!this.m_alShots.isEmpty()) {
                this.paintShot(graphics, this.m_alShots.get(this.m_alShots.size() - 1), this.m_oColShotMark);
            }
            this.m_alShots.add(point);
            this.getBattleShipsPanel().passShot(this.m_bEnemyField, point, false, false, 0, false, null);
        }
    }

    public void setPlaying(boolean bl) {
        Cursor cursor = bl ? this.m_bShootCursor : new Cursor(0);
        this.setCursor(cursor);
        this.m_bPlaying = bl;
        BattleShip battleShip = null;
        ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
        while (listIterator.hasNext()) {
            battleShip = listIterator.next();
            battleShip.setPlaying(bl);
            battleShip.setCursor(cursor);
        }
    }

    public void reset() {
        this.m_bPlaying = false;
        this.m_iSunkCount = 0;
        this.m_alShots.clear();
        BattleShip battleShip = null;
        Cursor cursor = new Cursor(12);
        ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
        while (listIterator.hasNext()) {
            battleShip = listIterator.next();
            if (this.m_bEnemyField) {
                this.remove(battleShip);
                continue;
            }
            battleShip.reset(this.m_iFieldType);
            if (this.m_iFieldType != 1) continue;
            battleShip.setCursor(cursor);
        }
        if (this.m_bEnemyField) {
            this.setCursor(new Cursor(0));
            this.m_alBattleShips.clear();
        }
        this.m_activeShips = (int[])this.m_iShipTypeCount.clone();
    }

    public void setAllBattleShipsVisible(boolean bl) {
        BattleShip battleShip = null;
        ListIterator<BattleShip> listIterator = this.m_alBattleShips.listIterator();
        while (listIterator.hasNext()) {
            battleShip = listIterator.next();
            if (battleShip.getSunk()) continue;
            battleShip.setVisible(bl);
        }
    }

    public BattleShip getShipPattern(int n) {
        return this.m_bsShipPattern[n - 1];
    }

    public void i_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16 && this.m_bEnemyField && this.m_bPlaying) {
            int n = Math.round(mouseEvent.getX() / this.m_iCellWidth);
            int n2 = Math.round(mouseEvent.getY() / this.m_iCellWidth);
            if (n < this.m_iFieldWidth && n2 < this.m_iFieldWidth) {
                this.addAndPaintShot(new Point(n, n2));
            }
        }
    }
}

