/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class BattleShipsPanel
extends Container
implements BattleShipsConnectionListener {
    private TextDisplayPanel m_oCntMain;
    private TextDisplayPanel m_oLblMyShips;
    private TextDisplayPanel m_oLblEnemyShips;
    private BattleShipsField m_oPlMyShips;
    private BattleShipsField m_oPlEnemyShips;
    private BattleShipsField m_oPlMyScore;
    private BattleShipsField m_oPlEnemyScore;
    private BattleShipsField m_oPlInfo;
    private BattleShipsField m_plTestShips;
    private TextDisplayPanel m_oTxtStatus;
    private TextField m_oTxtChatInput;
    private TextArea m_oTxtChatOutput;
    private GfxAnimatedButton m_oBtnReady;
    private GfxAnimatedButton m_oBtnToggleHideShips;
    private TextDisplayPanel m_oLblStatus;
    private TextDisplayPanel m_oLblChat;
    private boolean m_bPlaying;
    private Container m_oPnlConnect;
    private Container m_oPnlClient;
    private GfxAnimatedButton m_oBtnToggleConnect;
    private TextField m_oTxtServer;
    private TextField m_txtPort;
    private GfxAnimatedButton m_oBtnToggleServer;
    private int m_mode;
    private BattleShipsConnection m_oSchSocket;
    private boolean m_bServerRunning;
    private Checkbox m_oCbClient;
    private Checkbox m_oCbServer;
    private Checkbox m_cbComputer;
    private boolean m_bConnected;
    private boolean m_bMeReady;
    private boolean m_bEnemyReady;
    private boolean m_bMyTurn;
    private int m_iCellWidth;
    private int m_iFieldWidth;
    private int m_iServerPort;
    private boolean m_bShipsHidden;
    private AudioClipPlayer m_acpGameSounds;
    private AudioClipPath m_oAuGameStart;
    private AudioClipPath m_oAuShipHit;
    private AudioClipPath m_oAuShipSink;
    private AudioClipPath m_oAuGameWon;
    private AudioClipPath m_oAuGameLost;
    private AudioClipPath m_oAuConnect;
    private AudioClipPath m_oAuGameOver;
    private Image m_ImgOffScreenBuffer;
    private boolean m_bPlaySound;
    private TheTimerTask m_oTmrGameOver;
    private String m_sOriginalConfig;
    private String m_sCurrentConfig;
    private int[] m_iShipTypeCount;
    private StateDisplayPanel m_oCntState;
    private boolean m_bClientOnly;
    private boolean m_bConfigReady;
    private Label m_oLblScore;
    private Point m_oPntScore;
    private GfxButton m_oGfxBtnInfo;
    private GfxToggleButton m_oBtnToggleSound;
    private Color m_oColShip;
    private Color m_oColShipSunk;
    private CryptUtil m_oCryptUtil;
    private boolean m_bUseWebServer;
    private int m_iWebServerPort;
    private boolean m_bWebServerLog;
    private WebServer m_oWebServer;
    private Checkbox m_oCbRestoreWindow;
    private FontMetrics m_oFntMetrMain;
    private BattleShipsParentContainer m_oBspcParent;
    private boolean m_bHaveServerError;
    private TextDisplayPanel m_lblHost;
    private TextDisplayPanel m_lblPort;
    private TextDisplayPanel m_lblPlayerName;
    private Container m_pnlPlayerName;
    private TextField m_txtPlayerName;
    private GfxAnimatedButton m_btnSetPlayerName;
    private String m_playerName;
    private TextDisplayPanel m_cntSelectEnemy;
    private List m_lstPlayerName;
    private boolean m_connWithDedicatedServer;
    private boolean m_showSelectEnemy;
    private String m_enemyPlayerName;
    private GfxButton m_btnDisconnectEnemy;
    private TextDisplayPanel m_cntConfirmation;
    private TextDisplayPanel m_lblConfirmation;
    private TextDisplayPanel m_cntModalMask;
    private boolean m_connectToFirstPlayer;
    private boolean m_isBot;
    private BattleShipsBotLogic m_Ai;
    private TheTimerTask m_tmrTimeOut;
    private boolean m_gameOver;
    private boolean m_botPaused;
    private boolean m_autoBot;
    private boolean m_debug;
    private int m_timeOutSeconds;
    private boolean m_startBot;
    private boolean m_startServer;
    private BotThread m_botThread;
    private int m_botPort;
    private final int HORIZ_BORDER_PADDING = 15;
    private final int VERT_BORDER_PADDING = 8;
    private final int DEFAULT_CELL_WIDTH = 22;
    private final int DEFAULT_FIELD_WIDTH = 18;
    private final int MIN_FIELD_SIZE = 340;

    public BattleShipsPanel(boolean bl, boolean bl2) {
        this.m_bClientOnly = bl;
        this.m_debug = bl2;
        this.m_autoBot = false;
        this.m_startBot = false;
        this.m_startServer = false;
        this.m_botPort = 0;
    }

    public void init() {
        int n;
        Cursor cursor = null;
        this.setLayout(null);
        this.setBackground(Color.white);
        this.m_bPlaying = false;
        this.m_mode = 1;
        this.m_bServerRunning = false;
        this.m_bConnected = false;
        this.m_bMeReady = false;
        this.m_bEnemyReady = false;
        this.m_bMyTurn = false;
        this.m_bShipsHidden = false;
        this.m_iShipTypeCount = new int[6];
        this.m_bConfigReady = false;
        this.m_oBspcParent = (BattleShipsParentContainer)((Object)this.getParent());
        this.m_playerName = "";
        this.m_connWithDedicatedServer = false;
        this.m_showSelectEnemy = false;
        this.m_enemyPlayerName = "";
        this.m_connectToFirstPlayer = false;
        this.m_gameOver = true;
        this.m_botPaused = true;
        this.m_timeOutSeconds = 0;
        this.m_iCellWidth = this.parseIntParm("CellWidth", 22);
        this.m_iFieldWidth = this.parseIntParm("FieldWidth", 18);
        if (this.m_botPort > 0) {
            n = this.m_botPort;
        } else {
            n = this.parseIntParm("Port", 666, true);
            if (n < 1 || n > 65535) {
                n = 666;
            }
        }
        this.m_iServerPort = this.parseIntParm("ServerPort", 666);
        if (this.m_iServerPort < 1 || this.m_iServerPort > 65535) {
            this.m_iServerPort = 666;
        }
        this.m_botPort = this.m_iServerPort;
        this.m_bPlaySound = this.parseIntParm("PlaySound", 0, true) == 1;
        boolean bl = this.parseIntParm("RestoreWindow", 0, true) == 1;
        boolean bl2 = this.parseIntParm("UseLocalConfig", 0) == 1;
        Color color = this.parseColorParm("ColorPlayField", Color.white);
        Color color2 = this.parseColorParm("ColorPlayFieldLines", Color.black);
        this.m_oColShip = this.parseColorParm("ColorShip", Color.red);
        this.m_oColShipSunk = this.parseColorParm("ColorShipSunk", Color.magenta);
        Color color3 = this.parseColorParm("ColorShipHitMark", Color.black);
        Color color4 = this.parseColorParm("ColorShipHighlight", Color.blue);
        Color color5 = this.parseColorParm("ColorPlayFieldShotMark", Color.lightGray);
        Color color6 = this.parseColorParm("ColorPlayFieldShotMarkEnemy", Color.lightGray);
        Color color7 = this.parseColorParm("ColorPlayFieldLastShotMark", Color.gray);
        if (this.m_bClientOnly && !bl2) {
            this.m_sOriginalConfig = "";
        } else {
            this.m_sOriginalConfig = this.m_iCellWidth + ";" + this.m_iFieldWidth;
            for (int i = 1; i <= 6; ++i) {
                int n2;
                this.m_iShipTypeCount[i - 1] = n2 = this.parseIntParm("ShipTypeCount" + i, 1);
                this.m_sOriginalConfig = this.m_sOriginalConfig + ";" + n2;
            }
        }
        this.m_sCurrentConfig = this.m_sOriginalConfig;
        this.m_bUseWebServer = !this.m_bClientOnly && this.parseIntParm("UseWebServer", 0) == 1;
        this.m_bWebServerLog = this.parseIntParm("WebServerLog", 0) == 1;
        this.m_iWebServerPort = this.parseIntParm("WebServerPort", 80);
        if (this.m_iWebServerPort < 1 || this.m_iWebServerPort > 65535 || this.m_iWebServerPort == this.m_iServerPort) {
            this.m_iWebServerPort = 80;
        }
        Font font = new Font("SansSerif", 0, 14);
        Font font2 = new Font("SansSerif", 1, 14);
        Image image = this.getImage("res/bg_btn_on.gif");
        Image image2 = this.getImage("res/bg_btn_off.gif");
        this.m_oCntMain = (TextDisplayPanel)this.add(new TextDisplayPanel());
        this.m_oCntMain.setFont(font);
        this.m_oFntMetrMain = this.m_oCntMain.getFontMetrics(font);
        this.m_oPlInfo = (BattleShipsField)this.m_oCntMain.add(new BattleShipsField(6, 3));
        this.m_oPlInfo.setBackground(Color.white);
        this.m_oPlInfo.setForeground(Color.black);
        this.m_oPlInfo.setColorShip(this.m_oColShip);
        this.m_oPlInfo.setVisible(false);
        this.m_cntSelectEnemy = (TextDisplayPanel)this.m_oCntMain.add(new TextDisplayPanel());
        this.m_cntSelectEnemy.setForeground(Color.black);
        this.m_cntSelectEnemy.setBackground(Color.white);
        this.m_cntSelectEnemy.setPadding(2);
        this.m_cntSelectEnemy.setWithBorder(true);
        this.m_cntSelectEnemy.setSize(220, 250);
        TextDisplayPanel textDisplayPanel = (TextDisplayPanel)this.m_cntSelectEnemy.add(new TextDisplayPanel());
        textDisplayPanel.setLocation(3, 3);
        textDisplayPanel.setFont(font2);
        textDisplayPanel.setText(this.getString("SelectEnemy"), 1);
        this.m_lstPlayerName = (List)this.m_cntSelectEnemy.add(new List(10));
        this.m_lstPlayerName.setFont(font);
        this.m_lstPlayerName.addMouseListener(new TheMouseAdapter(this, "selE"));
        this.m_lstPlayerName.setBounds(5, this.m_oFntMetrMain.getHeight() + 5, this.m_cntSelectEnemy.getSize().width - 10, 180);
        GfxAnimatedButton gfxAnimatedButton = (GfxAnimatedButton)this.m_cntSelectEnemy.add(new GfxAnimatedButton(this, "se", image, image2));
        gfxAnimatedButton.setFont(font2);
        gfxAnimatedButton.setLabel(this.getString("Play"));
        int n3 = this.m_cntSelectEnemy.getSize().width / 2 - gfxAnimatedButton.getSize().width / 2;
        gfxAnimatedButton.setLocation(n3, this.m_oFntMetrMain.getHeight() + 5 + this.m_lstPlayerName.getSize().height + 8);
        this.m_cntSelectEnemy.setVisible(false);
        this.m_cntConfirmation = (TextDisplayPanel)this.m_oCntMain.add(new TextDisplayPanel());
        this.m_cntConfirmation.setForeground(Color.black);
        this.m_cntConfirmation.setBackground(Color.white);
        this.m_cntConfirmation.setWithBorder(true);
        this.m_cntConfirmation.setSize(220, 145);
        this.m_cntConfirmation.addMouseListener(new TheMouseAdapter(this, "dummy"));
        this.m_lblConfirmation = (TextDisplayPanel)this.m_cntConfirmation.add(new TextDisplayPanel());
        this.m_lblConfirmation.setLocation(0, 0);
        this.m_lblConfirmation.setPadding(5);
        this.m_lblConfirmation.setFont(font);
        this.m_lblConfirmation.setSize(this.m_cntConfirmation.getSize().width, 100);
        GfxAnimatedButton gfxAnimatedButton2 = (GfxAnimatedButton)this.m_cntConfirmation.add(new GfxAnimatedButton(this, "ok", image, image2));
        gfxAnimatedButton2.setFont(font);
        gfxAnimatedButton2.setLabel(this.getString("Ok"));
        gfxAnimatedButton2.setSize(this.m_oFntMetrMain.stringWidth(gfxAnimatedButton2.getLabel()) + 15, this.m_oFntMetrMain.getHeight() + 8);
        GfxAnimatedButton gfxAnimatedButton3 = (GfxAnimatedButton)this.m_cntConfirmation.add(new GfxAnimatedButton(this, "cancel", image, image2));
        gfxAnimatedButton3.setFont(font);
        gfxAnimatedButton3.setLabel(this.getString("Cancel"));
        gfxAnimatedButton3.setSize(this.m_oFntMetrMain.stringWidth(gfxAnimatedButton3.getLabel()) + 15, this.m_oFntMetrMain.getHeight() + 8);
        n3 = this.m_cntConfirmation.getSize().width / 2 - (gfxAnimatedButton2.getSize().width + 10 + gfxAnimatedButton3.getSize().width) / 2;
        gfxAnimatedButton2.setLocation(n3, this.m_lblConfirmation.getSize().height + 10);
        gfxAnimatedButton3.setLocation(n3 + gfxAnimatedButton2.getSize().width + 10, this.m_lblConfirmation.getSize().height + 10);
        this.m_cntConfirmation.setVisible(false);
        this.m_cntModalMask = (TextDisplayPanel)this.m_oCntMain.add(new TextDisplayPanel());
        this.m_cntModalMask.addMouseListener(new TheMouseAdapter(this, "dummy"));
        this.m_cntModalMask.setVisible(false);
        this.m_oCntState = (StateDisplayPanel)this.m_oCntMain.add(new StateDisplayPanel());
        this.m_oCntState.setBackground(Color.white);
        this.m_oCntState.setBounds(1, 1, 1, 1);
        this.m_oCntState.setVisible(false);
        this.m_oLblMyShips = (TextDisplayPanel)this.m_oCntMain.add(new TextDisplayPanel());
        this.m_oLblMyShips.setFont(font);
        this.m_oLblMyShips.setText(this.getString("MyShips"), 1);
        this.m_oGfxBtnInfo = (GfxButton)this.m_oCntMain.add(new GfxButton(this, "j", this.getImage("res/info.gif")));
        this.m_oGfxBtnInfo.setBounds(1, 1);
        this.m_oPlMyShips = (BattleShipsField)this.m_oCntMain.add(new BattleShipsField(6, 1));
        this.m_oPlMyShips.setLocation(15, 27);
        this.m_oPlMyShips.setBackground(color);
        this.m_oPlMyShips.setForeground(color2);
        this.m_oPlMyShips.setColorShotMark(color5);
        this.m_oPlMyShips.setColorLastShotMark(color7);
        this.m_oPlMyShips.setColorShip(this.m_oColShip);
        this.m_oPlMyShips.setColorShipSunk(this.m_oColShipSunk);
        this.m_oPlMyShips.setColorShipHitMark(color3);
        this.m_oPlMyShips.setColorShipHighlight(color4);
        this.m_oPlMyShips.setDebug(this.m_debug);
        this.m_oPlMyScore = (BattleShipsField)this.m_oCntMain.add(new BattleShipsField(6, 3));
        this.m_oPlMyScore.setBackground(color);
        this.m_oPlMyScore.setForeground(color2);
        this.m_oPlMyScore.setColorShip(this.m_oColShip);
        this.m_oPlMyScore.setColorShipSunk(this.m_oColShipSunk);
        this.m_oPlMyScore.init(4, 68);
        this.m_oLblEnemyShips = (TextDisplayPanel)this.m_oCntMain.add(new TextDisplayPanel());
        this.m_oLblEnemyShips.setFont(font);
        this.m_oLblEnemyShips.setText(this.getString("EnemyShips"), 1);
        this.m_oBtnToggleSound = (GfxToggleButton)this.m_oCntMain.add(new GfxToggleButton(this, "k", this.getImage("res/speaker_on.gif"), this.getImage("res/speaker_off.gif")));
        this.m_oBtnToggleSound.setBounds(1, 1);
        this.m_oBtnToggleSound.setOn(this.m_bPlaySound);
        try {
            cursor = Graphics2DFactory.getShootCursor(this.getImage("res/shoot_cursor.gif"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cursor == null) {
            cursor = new Cursor(1);
        }
        this.m_oPlEnemyShips = (BattleShipsField)this.m_oCntMain.add(new BattleShipsField(6, 2));
        this.m_oPlEnemyShips.setBackground(color);
        this.m_oPlEnemyShips.setForeground(color2);
        this.m_oPlEnemyShips.setColorShotMark(color6);
        this.m_oPlEnemyShips.setColorLastShotMark(color7);
        this.m_oPlEnemyShips.setColorShip(this.m_oColShip);
        this.m_oPlEnemyShips.setColorShipSunk(this.m_oColShipSunk);
        this.m_oPlEnemyShips.setColorShipHitMark(color3);
        this.m_oPlEnemyShips.setShootCursor(cursor);
        this.m_oPlEnemyShips.setDebug(this.m_debug);
        this.m_oPlEnemyScore = (BattleShipsField)this.m_oCntMain.add(new BattleShipsField(6, 3));
        this.m_oPlEnemyScore.setBackground(color);
        this.m_oPlEnemyScore.setForeground(color2);
        this.m_oPlEnemyScore.setColorShip(this.m_oColShip);
        this.m_oPlEnemyScore.setColorShipSunk(this.m_oColShipSunk);
        this.m_oPlEnemyScore.init(4, 68);
        if (this.m_isBot) {
            this.m_plTestShips = (BattleShipsField)this.m_oCntMain.add(new BattleShipsField(6, 1));
            this.m_plTestShips.setBackground(color);
            this.m_plTestShips.setForeground(color2);
            this.m_plTestShips.setColorShip(this.m_oColShip);
            this.m_plTestShips.setColorShipSunk(this.m_oColShipSunk);
            this.m_plTestShips.setVisible(false);
        }
        this.m_oBtnReady = (GfxAnimatedButton)this.m_oCntMain.add(new GfxAnimatedButton(this, "n", image, image2));
        this.m_oBtnReady.setFont(font2);
        this.m_oBtnReady.setLabel(this.getString("Ready"));
        this.m_oBtnReady.setEnabled(false);
        this.m_oBtnToggleHideShips = (GfxAnimatedButton)this.m_oCntMain.add(new GfxAnimatedButton(this, "h", image, image2));
        this.m_oBtnToggleHideShips.setFont(font);
        this.m_oBtnToggleHideShips.setLabel(this.getString("HideShips"));
        this.m_oLblStatus = (TextDisplayPanel)this.m_oCntMain.add(new TextDisplayPanel());
        this.m_oLblStatus.setFont(font);
        this.m_oLblStatus.setText(this.getString("Status"), 1);
        this.m_oLblScore = (Label)this.m_oCntMain.add(new Label());
        this.m_oLblScore.setFont(new Font("Monospaced", 0, 12));
        this.m_oLblScore.setVisible(false);
        this.m_oTxtStatus = (TextDisplayPanel)this.add(new TextDisplayPanel());
        this.m_oTxtStatus.setFont(font2);
        this.m_oTxtStatus.setBackground(Color.white);
        this.m_oTxtStatus.setPadding(2);
        this.m_oTxtStatus.setText(BattleShipsUtility.getCopyright());
        this.m_oTxtStatus.setWithBorder(true);
        this.m_oTxtStatus.addMouseListener(new TheMouseAdapter(this, "t"));
        Font font3 = new Font("SansSerif", 0, 12);
        this.m_oTxtChatInput = (TextField)this.m_oCntMain.add(new TextField());
        this.m_oTxtChatInput.setFont(font3);
        this.m_oTxtChatInput.setBackground(Color.white);
        this.m_oTxtChatInput.setEnabled(false);
        this.m_oTxtChatInput.addKeyListener(new TheKeyAdapter(this, "l"));
        this.m_oLblChat = (TextDisplayPanel)this.m_oCntMain.add(new TextDisplayPanel());
        this.m_oLblChat.setFont(font);
        this.m_oLblChat.setText(this.getString("Chat"), 1);
        this.m_oLblChat.addMouseListener(new TheMouseAdapter(this, "ch"));
        this.m_oTxtChatOutput = (TextArea)this.m_oCntMain.add(new TextArea("", 1, 1, 1));
        this.m_oTxtChatOutput.setEditable(false);
        this.m_oTxtChatOutput.setFont(font3);
        this.m_oTxtChatOutput.setBackground(Color.white);
        this.m_oPnlConnect = (Container)this.m_oCntMain.add(new Container());
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_oCbClient = (Checkbox)this.m_oPnlConnect.add(new Checkbox(this.getString("Client"), false, checkboxGroup));
        this.m_oCbClient.setFont(font);
        this.m_oCbClient.setLocation(0, 0);
        this.m_oCbClient.addMouseListener(new TheMouseAdapter(this, "x"));
        this.m_oCbServer = (Checkbox)this.m_oPnlConnect.add(new Checkbox(this.getString("Server"), true, checkboxGroup));
        this.m_oCbServer.setFont(font);
        this.m_oCbServer.setLocation(0, 18);
        this.m_oCbServer.addMouseListener(new TheMouseAdapter(this, "y"));
        this.m_cbComputer = (Checkbox)this.m_oPnlConnect.add(new Checkbox(this.getString("Computer"), true, checkboxGroup));
        this.m_cbComputer.setFont(font);
        this.m_cbComputer.setLocation(0, 36);
        this.m_cbComputer.addMouseListener(new TheMouseAdapter(this, "com"));
        this.m_oPnlClient = (Container)this.m_oPnlConnect.add(new Container());
        this.m_oPnlClient.setVisible(false);
        this.m_oTxtServer = (TextField)this.m_oPnlClient.add(new TextField(this.getHost()));
        this.m_oTxtServer.setFont(font3);
        this.m_oTxtServer.addKeyListener(new TheKeyAdapter(this, "r"));
        this.m_txtPort = (TextField)this.m_oPnlClient.add(new TextFieldWithLimit(Integer.toString(n), 5, 5));
        this.m_txtPort.setFont(font3);
        this.m_lblHost = (TextDisplayPanel)this.m_oPnlClient.add(new TextDisplayPanel());
        this.m_lblHost.setFont(font);
        this.m_lblHost.setText(this.getString("Host"), 1);
        this.m_lblHost.setLocation(0, -2);
        this.m_lblPort = (TextDisplayPanel)this.m_oPnlClient.add(new TextDisplayPanel());
        this.m_lblPort.setFont(font);
        this.m_lblPort.setText(this.getString("Port"), 1);
        this.m_lblPort.setLocation(151, -2);
        this.m_oBtnToggleConnect = (GfxAnimatedButton)this.m_oPnlClient.add(new GfxAnimatedButton(this, "q", image, image2));
        this.m_oBtnToggleConnect.setFont(font);
        this.m_oBtnToggleConnect.setLabel(this.getString("Connect"));
        this.m_oBtnToggleServer = (GfxAnimatedButton)this.m_oPnlConnect.add(new GfxAnimatedButton(this, "g", image, image2));
        this.m_oBtnToggleServer.setFont(font);
        this.m_oBtnToggleServer.setLabel(this.getString("ServerStart"));
        this.m_oCbRestoreWindow = (Checkbox)this.m_oPnlConnect.add(new Checkbox(this.getString("RestoreWindow"), bl));
        this.m_oCbRestoreWindow.setFont(font);
        this.m_oCbRestoreWindow.addMouseListener(new TheMouseAdapter(this, "rw"));
        this.m_oCryptUtil = new CryptUtil();
        this.m_pnlPlayerName = (Container)this.m_oPnlClient.add(new Container());
        this.m_pnlPlayerName.setVisible(true);
        this.m_txtPlayerName = (TextField)this.m_pnlPlayerName.add(new TextFieldWithLimit(20));
        this.m_txtPlayerName.setFont(font3);
        this.m_txtPlayerName.setLocation(0, 1);
        this.m_txtPlayerName.setBackground(Color.white);
        this.m_txtPlayerName.addKeyListener(new TheKeyAdapter(this, "pn"));
        this.m_lblPlayerName = (TextDisplayPanel)this.m_pnlPlayerName.add(new TextDisplayPanel());
        this.m_lblPlayerName.setFont(font);
        this.m_lblPlayerName.setText(this.getString("PlayerName"), 1);
        this.m_lblPlayerName.setLocation(0, -2);
        this.m_lblPlayerName.addMouseListener(new TheMouseAdapter(this, "fps"));
        this.m_btnSetPlayerName = (GfxAnimatedButton)this.m_pnlPlayerName.add(new GfxAnimatedButton(this, "spn", image, image2));
        this.m_btnSetPlayerName.setFont(font);
        this.m_btnSetPlayerName.setLabel(this.getString("Set"));
        this.m_btnSetPlayerName.setEnabled(false);
        this.m_btnDisconnectEnemy = (GfxButton)this.m_pnlPlayerName.add(new GfxButton(this, "de", this.getImage("res/disconnect.gif")));
        this.m_btnDisconnectEnemy.setBounds(1, 1);
        this.m_btnDisconnectEnemy.setVisible(false);
        this.setPlayerName(this.getCookie("PlayerName"));
        try {
            this.m_mode = Integer.parseInt(this.getCookie("Mode"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.m_startBot) {
            this.m_mode = 3;
        } else if (this.m_startServer) {
            this.m_mode = 2;
        }
        this.setMode(this.m_mode, false);
        this.initAudioSystem();
        if (this.m_bClientOnly && !bl2) {
            this.m_mode = 1;
            this.setBounds(0, this.getParent().getInsets().top, 400, 300);
            this.remove(this.m_oTxtStatus);
            this.add((Component)this.m_oTxtStatus, 0);
            this.m_oTxtStatus.setBounds(15, 8, 300, 82);
            this.connect();
        } else {
            boolean bl3 = this.initConfig();
            if (bl3) {
                if (this.m_startServer || this.m_startBot) {
                    this.startServer();
                    this.setStatus(this.getString("ServerStarted"));
                    if (this.m_bUseWebServer) {
                        this.startWebServer();
                    }
                }
                if (this.m_startBot) {
                    this.m_botThread = new BotThread();
                    this.m_botThread.start();
                }
            }
        }
    }

    private void initAudioSystem() {
        this.m_acpGameSounds = new AudioClipPlayer(this.m_debug);
        this.m_oAuGameStart = this.getAudioClipPath("snd/game_start");
        this.m_acpGameSounds.loadAudioClip(this.m_oAuGameStart);
        this.m_oAuShipHit = this.getAudioClipPath("snd/ship_hit");
        this.m_acpGameSounds.loadAudioClip(this.m_oAuShipHit);
        this.m_oAuShipSink = this.getAudioClipPath("snd/ship_sink");
        this.m_acpGameSounds.loadAudioClip(this.m_oAuShipSink);
        this.m_oAuGameWon = this.getAudioClipPath("snd/game_won");
        this.m_acpGameSounds.loadAudioClip(this.m_oAuGameWon);
        this.m_oAuGameLost = this.getAudioClipPath("snd/game_lost");
        this.m_acpGameSounds.loadAudioClip(this.m_oAuGameLost);
        this.m_oAuConnect = this.getAudioClipPath("snd/connect");
        this.m_acpGameSounds.loadAudioClip(this.m_oAuConnect);
    }

    public void stop() {
        if (this.m_oSchSocket != null) {
            this.m_oSchSocket.interrupt();
        }
        if (this.m_oWebServer != null) {
            this.m_oWebServer.interrupt();
        }
        if (this.m_oTmrGameOver != null) {
            this.m_oTmrGameOver.interrupt();
        }
        this.m_oCntState.stop();
    }

    private Image buildShipSegment(Color color, int n) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[--n * n];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = color.getRed();
        int n9 = color.getGreen();
        int n10 = color.getBlue();
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                n5 = this.calcComp(n2, n3, n8, n);
                n6 = this.calcComp(n2, n3, n9, n);
                n7 = this.calcComp(n2, n3, n10, n);
                nArray[n4++] = 0xFF000000 | n5 << 16 | n6 << 8 | n7;
            }
        }
        return this.createImage(new MemoryImageSource(n, n, nArray, 0, n));
    }

    private int calcComp(int n, int n2, int n3, int n4) {
        int n5 = n * n3 / 2 / (n4 - 1) + n2 * n3 / 2 / (n4 - 1) + Math.round(n3 / 3);
        if (n5 > 255) {
            n5 = 255;
        }
        return n5;
    }

    private boolean initConfig() {
        int n;
        FontMetrics fontMetrics = this.m_oCntMain.getFontMetrics(this.m_oTxtChatInput.getFont());
        FontMetrics fontMetrics2 = this.m_oCntMain.getFontMetrics(this.m_oLblScore.getFont());
        int n2 = this.m_oFntMetrMain.getHeight();
        int n3 = fontMetrics.getHeight() + fontMetrics.getMaxDescent() * 2;
        Container container = this.getParent();
        int n4 = container.getInsets().top;
        boolean bl = true;
        int n5 = Math.round(this.m_iCellWidth * 77 / 100);
        if (n5 < 14) {
            n5 = 14;
        }
        int n6 = 28;
        int n7 = (int)Math.round((double)(this.m_iCellWidth * this.m_iFieldWidth) / 100.0 * 12.5);
        Image image = this.buildShipSegment(this.m_oColShip, this.m_iCellWidth);
        Image image2 = this.buildShipSegment(this.m_oColShipSunk, this.m_iCellWidth);
        this.m_oLblMyShips.setLocation(15, 8);
        this.m_oPlInfo.removeAllShips();
        this.m_oPlInfo.init(n5, 14);
        this.m_oPlInfo.setImageShipSegment(this.buildShipSegment(this.m_oColShip, n5));
        this.m_oPlMyShips.removeAllShips();
        this.m_oPlMyShips.init(this.m_iCellWidth, this.m_iFieldWidth);
        this.m_oPlMyShips.setImageShipSegment(image);
        this.m_oPlMyShips.setImageShipSegmentSunk(image2);
        this.m_oPlMyScore.removeAllShips();
        this.m_oPlEnemyShips.removeAllShips();
        this.m_oPlEnemyShips.init(this.m_iCellWidth, this.m_iFieldWidth);
        this.m_oPlEnemyShips.setImageShipSegment(image);
        this.m_oPlEnemyShips.setImageShipSegmentSunk(image2);
        this.m_oPlEnemyScore.removeAllShips();
        for (int i = 1; i <= 6; ++i) {
            int n8 = this.m_iShipTypeCount[i - 1];
            this.m_oPlMyShips.setShipTypeCount(i, n8);
            this.m_oPlMyScore.setShipTypeCount(i, n8);
            this.m_oPlEnemyScore.setShipTypeCount(i, n8);
            this.m_oPlInfo.setShipTypeCount(i, n8);
        }
        if (!this.m_oPlMyShips.addAllMyShips()) {
            this.m_oPlMyShips.removeAllShips();
            this.m_oCbClient.setEnabled(false);
            this.m_oCbServer.setEnabled(false);
            this.m_cbComputer.setEnabled(false);
            this.m_oTxtServer.setEnabled(false);
            this.m_txtPort.setEnabled(false);
            this.m_oBtnToggleConnect.setEnabled(false);
            this.m_oBtnToggleServer.setEnabled(false);
            this.m_oBtnToggleHideShips.setEnabled(false);
            this.setStatus(this.getString("FieldTooSmall"));
            bl = false;
        }
        this.m_oPlMyScore.addAllMyShips();
        this.m_oPlEnemyScore.addAllMyShips();
        if (this.m_isBot) {
            this.m_plTestShips.removeAllShips();
            this.m_plTestShips.init(4, this.m_iFieldWidth);
            this.m_plTestShips.addTestShips();
        }
        if ((n = this.m_oPlMyShips.getSize().width) < 340) {
            n = 340;
        }
        int n9 = n + 8 + n6 + 221;
        int n10 = n * 2 + 45;
        container.setSize(n10, n9 + n4);
        this.setBounds(0, n4, n10, n9);
        this.m_oCntMain.setBounds(0, 0, n10, n9);
        this.m_cntModalMask.setBounds(0, 0, n10, n9);
        this.m_oGfxBtnInfo.setLocation(15 + n - 16, 8);
        this.m_oPlInfo.addShipsAndInfo();
        this.m_oPlInfo.setLocation(this.m_oPlInfo.getLocation().x, 27 + Math.round(this.m_iCellWidth / 2));
        this.m_oPlMyScore.setBounds(15, 8 + n + 18, n, n6);
        this.m_oLblEnemyShips.setLocation(15 + n + 15, 8);
        this.m_oBtnToggleSound.setLocation(15 + n + 15 + (n - 16), 8);
        this.m_oPlEnemyShips.setLocation(15 + n + 15, 27);
        this.m_oPlEnemyScore.setBounds(15 + n + 15, 8 + n + 18, n, n6);
        this.m_oBtnReady.setLocation(15, 8 + n + n6 + 22);
        this.m_oBtnToggleHideShips.setLocation(15 + n - (this.m_oFntMetrMain.stringWidth(this.m_oBtnToggleHideShips.getLabel()) + 15), 8 + n + n6 + 22);
        this.m_oLblStatus.setLocation(15, 8 + n + n6 + 50);
        this.m_oLblScore.setText(this.getString("You") + ":00 " + this.getString("Enemy") + ":00");
        this.m_oLblScore.setBounds(15 + n - (fontMetrics2.stringWidth(this.m_oLblScore.getText()) + 5), 8 + n + n6 + 52, fontMetrics2.stringWidth(this.m_oLblScore.getText()) + 5, fontMetrics2.getHeight());
        this.m_oTxtStatus.setBounds(15, 8 + n + n6 + 69, n, 82);
        this.m_oLblChat.setLocation(15 + n + 15, 8 + n + n6 + 20);
        this.m_oTxtChatInput.setBounds(15 + n + 15, 8 + n + n6 + 39, n, n3);
        this.m_oTxtChatOutput.setBounds(15 + n + 15, 8 + n + n3 + n6 + 40, n, 112 - n3);
        this.m_oPnlConnect.setBounds(15, 8 + n + n6 + 156, n * 2 + 15, n2 * 3);
        this.m_oCbClient.setSize(this.m_oFntMetrMain.stringWidth(this.m_oCbClient.getLabel()) + 20, n2);
        this.m_oCbServer.setSize(this.m_oFntMetrMain.stringWidth(this.m_oCbServer.getLabel()) + 20, n2);
        this.m_cbComputer.setSize(this.m_oFntMetrMain.stringWidth(this.m_cbComputer.getLabel()) + 20, n2);
        this.m_oTxtServer.setBounds(0, n2 - 2, 150, n3);
        this.m_txtPort.setBounds(151, n2 - 2, 35, n3);
        this.m_oBtnToggleConnect.setLocation(187, n2 - 2);
        this.m_oBtnToggleConnect.setSize(this.m_oBtnToggleConnect.getSize().width, n3 - 1);
        this.m_oPnlClient.setBounds(this.m_oFntMetrMain.stringWidth(this.m_cbComputer.getLabel()) + 25, 0, n * 2 + 15 - (this.m_oFntMetrMain.stringWidth(this.m_oCbServer.getLabel()) + 30), n3 * 2);
        this.m_oBtnToggleServer.setLocation(this.m_oFntMetrMain.stringWidth(this.m_cbComputer.getLabel()) + 30, 5);
        this.m_oCbRestoreWindow.setBounds(15 + n + (n - (this.m_oFntMetrMain.stringWidth(this.m_oCbRestoreWindow.getLabel()) + 20)), 0, this.m_oFntMetrMain.stringWidth(this.m_oCbRestoreWindow.getLabel()) + 20, n2);
        this.m_pnlPlayerName.setBounds(n - this.m_oFntMetrMain.stringWidth(this.m_cbComputer.getLabel()) - 15, 0, n, n2 * 2);
        this.m_txtPlayerName.setBounds(0, n2 - 2, 170, n3);
        this.m_btnSetPlayerName.setLocation(171, n2 - 2);
        this.m_btnSetPlayerName.setSize(this.m_btnSetPlayerName.getSize().width, n3 - 1);
        this.m_btnDisconnectEnemy.setLocation(this.m_pnlPlayerName.getSize().width - 25, n2 - 6);
        this.m_cntSelectEnemy.setLocation(2 * n + 30 - this.m_cntSelectEnemy.getSize().width - 5, n + 8 + 19 - this.m_cntSelectEnemy.getSize().height - 5);
        this.m_cntConfirmation.setLocation((2 * n + 15 + 30) / 2 - this.m_cntConfirmation.getSize().width / 2, 8 + n / 2 - this.m_cntConfirmation.getSize().height / 2);
        this.m_oCntState.setFont(new Font("SansSerif", 1, n7));
        if (this.m_bClientOnly) {
            this.m_oCbClient.setVisible(false);
            this.m_oCbServer.setVisible(false);
            this.m_cbComputer.setVisible(false);
            this.m_oCbRestoreWindow.setVisible(false);
            this.m_oBtnToggleServer.setVisible(false);
            this.m_oBtnToggleConnect.setVisible(false);
            this.m_oTxtServer.setVisible(false);
            this.m_txtPort.setVisible(false);
            this.m_lblHost.setVisible(false);
            this.m_lblPort.setVisible(false);
            this.m_oPnlClient.setVisible(true);
        }
        return bl;
    }

    public void setIsBot(boolean bl, boolean bl2, int n) {
        this.m_isBot = bl;
        this.m_autoBot = bl2;
        this.m_botPort = n;
    }

    public void setTimeOutSeconds(int n) {
        this.m_timeOutSeconds = n;
    }

    public void setStartBot(boolean bl) {
        this.m_startBot = bl;
    }

    public void setStartServer(boolean bl) {
        this.m_startServer = bl;
    }

    public void passShot(boolean bl, Point point, boolean bl2, boolean bl3, int n, boolean bl4, ArrayList<Point> arrayList) {
        if (this.m_bPlaySound) {
            if (bl3) {
                this.playAudioClip(this.m_oAuShipSink);
                if (bl4) {
                    this.m_oAuGameOver = bl ? this.m_oAuGameWon : this.m_oAuGameLost;
                }
            } else if (bl2) {
                this.playAudioClip(this.m_oAuShipHit);
            }
        }
        String string = bl ? this.getString("You") + ":" : (!this.m_enemyPlayerName.equals("") ? this.m_enemyPlayerName + ":" : this.getString("Enemy") + ":");
        string = string + " " + MessageFormat.format(this.getString("Shot"), Integer.toString(point.x + 1), Integer.toString(point.y + 1));
        if (bl2) {
            string = string + " " + this.getString("Hit");
        }
        if (bl3) {
            string = string + " " + this.getString("Sunk") + " (" + this.getString("BattleShipType" + n) + ")";
            if (bl) {
                this.m_oPlEnemyScore.sinkShip(n);
            } else {
                this.m_oPlMyScore.sinkShip(n);
            }
        }
        if (bl4) {
            Color color;
            String string2;
            if (bl) {
                string2 = this.getString("Won");
                color = new Color(0, 130, 0);
                ++this.m_oPntScore.x;
            } else {
                string2 = this.getString("Lost");
                color = new Color(180, 0, 0);
                ++this.m_oPntScore.y;
            }
            this.m_gameOver = true;
            this.m_botPaused = true;
            this.m_oPlEnemyShips.setPlaying(false);
            this.setButtonLabelAndSize(this.m_oBtnReady, this.getString("NewGame"), false);
            this.m_oBtnReady.setEnabled(true);
            this.m_oCntState.setText(string2);
            this.m_oCntState.setForeground(color);
            this.m_oTmrGameOver = new TheTimerTask(this, "i");
            this.m_oTmrGameOver.start(1600L, 0L);
            this.setScore();
            string = string + "\n" + string2;
            this.setStatus(string);
            if (bl) {
                this.sendMessage("shoot", point.x + ";" + point.y);
                this.sendMessage("gameresult", this.m_oPntScore.x + ";" + this.m_oPntScore.y);
            }
            if (this.m_isBot) {
                // empty if block
            }
        } else {
            this.setStatus(string);
            if (!bl2) {
                this.m_bMyTurn = !bl;
            }
            this.setTurn(false);
            if (bl) {
                this.sendMessage("shoot", point.x + ";" + point.y);
                if (this.m_isBot) {
                    this.m_Ai.reportLastShot(point, bl2, bl3, arrayList);
                }
            }
            if (!bl2) {
                if (!bl && this.m_isBot) {
                    this.shootBot();
                }
            } else if (bl && this.m_isBot) {
                this.shootBot();
            }
        }
    }

    private void shootBot() {
        if (!this.m_botPaused) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_oPlEnemyShips.shoot(this.m_Ai.getNextShot());
        }
    }

    private void setScoreBounds() {
        FontMetrics fontMetrics = this.m_oCntMain.getFontMetrics(this.m_oLblScore.getFont());
        int n = fontMetrics.stringWidth(this.m_oLblScore.getText());
        int n2 = this.m_oPlMyShips.getSize().width;
        this.m_oLblScore.setBounds(15 + n2 - (n + 5), 8 + n2 + this.m_oPlMyScore.getSize().height + 52, n + 5, fontMetrics.getHeight());
    }

    private void setStatus(String string) {
        this.m_oTxtStatus.setText(string);
    }

    private void appendStatus(String string) {
        this.m_oTxtStatus.append("\n" + string);
    }

    private int parseIntParm(String string, int n) {
        string = this.getParameter(string);
        int n2 = n;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private int parseIntParm(String string, int n, boolean bl) {
        int n2 = n;
        String string2 = this.getCookie(string);
        try {
            if (string2 != null && !string2.equals("")) {
                n2 = Integer.parseInt(string2);
            } else if ((string = this.getParameter(string)) != null) {
                n2 = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    private Color parseColorParm(String string, Color color) {
        string = this.getParameter(string);
        Color color2 = color;
        int[] nArray = new int[3];
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() == 3) {
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
                        if (nArray[n] >= 0 && nArray[n] <= 255) {
                            ++n;
                            continue;
                        }
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n == 3) {
                color2 = new Color(nArray[0], nArray[1], nArray[2]);
            }
        }
        return color2;
    }

    private void changeConfig(String string) {
        boolean bl = false;
        if (this.m_sCurrentConfig.equals(string)) {
            this.m_bConfigReady = true;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.m_iCellWidth = Integer.parseInt(stringTokenizer.nextToken());
        this.m_iFieldWidth = Integer.parseInt(stringTokenizer.nextToken());
        for (int i = 1; i <= 6; ++i) {
            int n;
            if (!stringTokenizer.hasMoreTokens()) {
                bl = true;
                break;
            }
            this.m_iShipTypeCount[i - 1] = n = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            bl = true;
        }
        if (bl) {
            this.setStatus(this.getString("VersionConflict"));
            this.stopConnect();
        } else {
            this.m_sCurrentConfig = string;
            this.initConfig();
            if (!this.m_bClientOnly) {
                this.appendStatus(this.getString("ConfigChange"));
            }
            this.repaint();
        }
        this.m_bConfigReady = true;
    }

    private void setScore() {
        String string = this.getString("You") + ":" + BattleShipsUtility.getZeroed(this.m_oPntScore.x) + " " + (!this.m_enemyPlayerName.equals("") ? this.m_enemyPlayerName : this.getString("Enemy")) + ":" + BattleShipsUtility.getZeroed(this.m_oPntScore.y);
        this.m_oLblScore.setText(string);
    }

    public String getString(String string) {
        String string2 = this.getParameter("String_" + string);
        if (string2.indexOf("{br}") > -1) {
            string2 = StringTool.replace(string2, "{br}", "\n");
        }
        return string2;
    }

    private String getParameter(String string) {
        return this.m_oBspcParent.getParameter(string);
    }

    private String getParameter(String string, String string2) {
        return this.m_oBspcParent.getParameter(string, string2);
    }

    private String getHost() {
        return this.m_oBspcParent.getHost();
    }

    private AudioClipPath getAudioClipPath(String string) {
        AudioClipPath audioClipPath = new AudioClipPath();
        String string2 = string + ".wav";
        URL uRL = this.m_oBspcParent.getAudioClipUrl(string2);
        audioClipPath.setUrl(uRL);
        string2 = string + ".au";
        uRL = this.m_oBspcParent.getAudioClipUrl(string2);
        audioClipPath.setFallbackUrl(uRL);
        return audioClipPath;
    }

    private Image getImage(String string) {
        return this.m_oBspcParent.getImage(string);
    }

    private void setNormalState() {
        this.m_oBspcParent.setNormalState();
    }

    private void setCookie(String string, String string2) {
        this.m_oBspcParent.setCookie(string, string2, 365);
    }

    private String getCookie(String string) {
        return this.m_oBspcParent.getCookie(string);
    }

    public boolean isConfigReady() {
        return this.m_bConfigReady;
    }

    public boolean isConnected() {
        return this.m_bConnected;
    }

    public void setPlayerName(String string) {
        this.m_txtPlayerName.setText(string);
        this.setServerPlayerName();
    }

    @Override
    public void socketDataArrived(String string, String string2) {
        StringTokenizer stringTokenizer = null;
        boolean bl = false;
        if (string.equals("shoot")) {
            stringTokenizer = new StringTokenizer(string2, ";");
            Point point = new Point(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            this.m_oPlMyShips.shoot(point);
            bl = true;
        } else if (string.equals("shipinfo")) {
            this.m_oPlEnemyShips.addAllEnemyShips(this.m_oCryptUtil.decode(string2));
            this.setStatusCondName("EnemyReady");
            this.m_bEnemyReady = true;
            this.setTurn(true);
            if (this.m_bMeReady) {
                this.m_oBtnReady.setEnabled(false);
            }
            if (this.m_isBot) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.setReady();
            }
            bl = true;
        } else if (string.equals("newgame")) {
            this.reset();
            this.setStatus(this.getString("NewGame"));
            if (this.m_isBot) {
                this.m_Ai = new BattleShipsBotLogic(this.m_iFieldWidth, this.m_debug);
                this.m_Ai.setTestShipsPanel(this.m_plTestShips);
                this.m_Ai.setEnemyScorePanel(this.m_oPlEnemyScore);
                this.m_oPlMyShips.setShipsRandomPosition();
                this.m_botPaused = false;
            }
            bl = true;
        } else if (string.equals("chat")) {
            if (!this.m_enemyPlayerName.equals("")) {
                this.m_oTxtChatOutput.append(this.m_enemyPlayerName + "> " + string2 + "\n");
            } else {
                this.m_oTxtChatOutput.append(this.getString("Enemy") + "> " + string2 + "\n");
            }
            bl = true;
        } else if (string.equals("serverresponse")) {
            this.m_oTxtChatOutput.append(this.getString("Server") + "> " + string2 + "\n");
        } else if (string.equals("config")) {
            this.changeConfig(string2);
        } else if (string.equals("disconnected")) {
            this.stopConnect();
            this.setStatus(this.getString("Disconnected"));
            if (this.m_bClientOnly) {
                this.appendStatus(this.getString("RefreshPage"));
                this.connect();
            }
            if (this.m_mode != 1) {
                this.startServer();
            }
            if (this.m_tmrTimeOut != null) {
                this.m_tmrTimeOut.interrupt();
            }
        } else if (string.equals("playernameset")) {
            this.m_playerName = string2;
            this.setCookie("PlayerName", this.m_playerName);
            this.m_oTxtChatOutput.append(this.getString("Server") + "> " + this.getString("PlayerNameSet") + ": " + string2 + "\n");
            this.m_oBspcParent.setWindowTitle(this.m_playerName + "@" + this.m_oTxtServer.getText());
        } else if (string.equals("playernameexists")) {
            if (!this.m_playerName.equals("")) {
                this.m_txtPlayerName.setText(this.m_playerName);
            }
            this.m_oTxtChatOutput.append(this.getString("Server") + "> " + this.getString("PlayerNameExists") + ": " + string2 + "\n");
            this.stopConnect();
            this.setStatus(this.getString("Disconnected"));
            if (this.m_tmrTimeOut != null) {
                this.m_tmrTimeOut.interrupt();
            }
        } else if (string.equals("clientlistupdate")) {
            this.m_connWithDedicatedServer = true;
            this.updatePlayerList(string2);
        } else if (string.equals("enemyfound")) {
            this.m_enemyPlayerName = string2;
            this.setStatus(MessageFormat.format(this.getString("EnemyFoundName"), this.m_enemyPlayerName));
            this.m_oLblEnemyShips.setText(MessageFormat.format(this.getString("EnemyShipsName"), this.m_enemyPlayerName), 1);
            this.m_btnDisconnectEnemy.setVisible(true);
            if (this.m_isBot) {
                this.m_oPlMyShips.setShipsRandomPosition();
            }
            this.setEnemyFound();
            bl = true;
        } else if (string.equals("status")) {
            if (string2.equals("Connected")) {
                if (this.m_mode == 3) {
                    this.setStatus(this.getString("BotStarted"));
                } else {
                    this.setStatus(this.getString("Connected"));
                }
                this.m_oBtnReady.setEnabled(true);
                this.m_oTxtChatInput.setEnabled(true);
                this.m_oPntScore = new Point(0, 0);
                this.m_oLblScore.setVisible(true);
                this.m_btnSetPlayerName.setEnabled(true);
                this.setScore();
                this.setScoreBounds();
                this.setServerPlayerName();
                if (!this.m_bClientOnly) {
                    this.setCookie("ServerName", this.m_oTxtServer.getText());
                    this.setCookie("Port", this.m_txtPort.getText());
                }
                if (this.m_mode != 1) {
                    if (!this.m_bClientOnly && this.m_oCbRestoreWindow.getState()) {
                        this.setNormalState();
                    }
                    if (this.m_mode != 3 && this.m_bPlaySound) {
                        this.playAudioClip(this.m_oAuConnect);
                    }
                    this.sendMessage("config", this.m_sCurrentConfig);
                }
            } else if (string2.equals("Waiting")) {
                this.m_oBtnReady.setEnabled(false);
                this.m_oLblScore.setVisible(false);
                this.m_showSelectEnemy = true;
                this.appendStatus(this.getString("Waiting"));
            } else if (string2.equals("EnemyFound")) {
                this.setStatus(this.getString("EnemyFound"));
                this.setEnemyFound();
                bl = true;
            } else if (string2.equals("EnemyChanged")) {
                this.reset();
                this.m_oBtnReady.setEnabled(true);
                this.m_oPntScore = new Point(0, 0);
                this.m_oLblScore.setVisible(true);
                this.setScore();
                this.setStatus(this.getString("EnemyLeft"));
                this.appendStatus(this.getString("NewEnemy"));
                if (this.m_bPlaySound) {
                    this.playAudioClip(this.m_oAuConnect);
                }
                bl = true;
            } else if (string2.equals("EnemyLeft")) {
                this.reset();
                this.m_oBtnReady.setEnabled(false);
                this.m_oLblScore.setVisible(false);
                this.m_showSelectEnemy = true;
                this.toggleSelectEnemy(true);
                this.togglePlayerNameControls(true);
                this.setStatusCondName("EnemyLeft");
                this.m_oLblEnemyShips.setText(this.getString("EnemyShips"), 1);
                this.toggleConfirmation(null);
                this.m_btnDisconnectEnemy.setVisible(false);
                this.appendStatus(this.getString("Waiting"));
                this.m_enemyPlayerName = "";
                if (this.m_tmrTimeOut != null) {
                    this.m_tmrTimeOut.interrupt();
                }
            }
        }
        if (this.m_isBot && bl) {
            this.refreshTimeOut();
        }
    }

    private void refreshTimeOut() {
        if (this.m_tmrTimeOut != null) {
            this.m_tmrTimeOut.interrupt();
        }
        if (this.m_timeOutSeconds > 0) {
            this.m_tmrTimeOut = new TheTimerTask(this, "tu");
            this.m_tmrTimeOut.start(this.m_timeOutSeconds * 1000, 0L);
        }
    }

    private void toggleConfirmation(String string) {
        if (string == null) {
            this.m_cntModalMask.setVisible(false);
            this.m_cntConfirmation.setVisible(false);
        } else {
            this.m_cntModalMask.setVisible(true);
            this.m_lblConfirmation.setText(string, 0);
            this.m_cntConfirmation.setVisible(true);
        }
    }

    private void setStatusCondName(String string) {
        if (!this.m_enemyPlayerName.equals("")) {
            this.setStatus(MessageFormat.format(this.getString(string + "Name"), this.m_enemyPlayerName));
        } else {
            this.setStatus(this.getString(string));
        }
    }

    private void setEnemyFound() {
        this.m_oBtnReady.setEnabled(true);
        this.m_oPntScore = new Point(0, 0);
        this.m_oLblScore.setVisible(true);
        this.m_showSelectEnemy = false;
        this.toggleSelectEnemy(false);
        this.togglePlayerNameControls(false);
        this.setScore();
        this.setScoreBounds();
        if (this.m_bPlaySound) {
            this.playAudioClip(this.m_oAuConnect);
        }
    }

    private void toggleSelectEnemy(boolean bl) {
        if (this.m_connWithDedicatedServer && (this.m_showSelectEnemy || !bl)) {
            this.m_cntSelectEnemy.setVisible(bl);
            if (this.m_connectToFirstPlayer && bl) {
                this.m_lstPlayerName.select(0);
                this.requestGame();
            }
        }
    }

    private void togglePlayerNameControls(boolean bl) {
        this.m_txtPlayerName.setEnabled(bl);
        this.m_btnSetPlayerName.setEnabled(bl);
    }

    private void updatePlayerList(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        this.m_lstPlayerName.removeAll();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
            bl = true;
        }
        if (bl) {
            Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                this.m_lstPlayerName.add((String)listIterator.next());
            }
        }
        this.toggleSelectEnemy(bl);
    }

    @Override
    public void socketDataArrived(String string, String string2, String string3) {
    }

    @Override
    public void socketError(String string, String string2) {
        String string3 = this.getString("Error") + " ";
        this.m_oTxtStatus.setBackground(Color.white);
        if (string.equals("UnknownHost")) {
            string3 = string3 + this.getString("UnknownHost");
        } else if (string.equals("ServerStart")) {
            string3 = string2.indexOf("Address already in use") > -1 ? string3 + MessageFormat.format(this.getString("ServerPortInUse"), String.valueOf(this.m_iServerPort)) : (string2.indexOf("socket closed") > -1 ? this.getString("ServerStopped") : string3 + string2);
        } else if (string.equals("General")) {
            if (string2.indexOf("Connection refused") > -1) {
                string3 = string3 + this.getString("ServerNotRunning");
                if (this.m_bClientOnly) {
                    string3 = string3 + " " + this.getString("RefreshPage");
                }
            } else {
                string3 = string3 + string2;
            }
        }
        this.m_bHaveServerError = true;
        this.stopConnect();
        this.setStatus(string3);
    }

    @Override
    public void socketError(String string, String string2, String string3) {
    }

    private void sendMessage(String string, String string2) {
        if (this.m_oSchSocket != null) {
            this.m_oSchSocket.sendMessage(string, string2);
        }
    }

    private void setTurn(boolean bl) {
        if (this.m_bMeReady && this.m_bEnemyReady) {
            if (this.m_bPlaySound && bl) {
                this.playAudioClip(this.m_oAuGameStart);
            }
            if (this.m_bMyTurn) {
                this.m_oPlEnemyShips.setPlaying(true);
                this.m_oTxtStatus.setBackground(new Color(120, 255, 120));
                this.appendStatus(this.getString("YourTurn"));
            } else {
                this.m_oPlEnemyShips.setPlaying(false);
                this.m_oTxtStatus.setBackground(new Color(255, 90, 90));
                if (!this.m_enemyPlayerName.equals("")) {
                    this.appendStatus(MessageFormat.format(this.getString("EnemyTurnName"), this.m_enemyPlayerName));
                } else {
                    this.appendStatus(this.getString("EnemyTurn"));
                }
            }
        }
    }

    private void reset() {
        this.m_bPlaying = false;
        this.m_gameOver = true;
        this.m_botPaused = true;
        this.m_bMeReady = false;
        this.m_bEnemyReady = false;
        this.m_bMyTurn = false;
        this.m_oPlMyShips.reset();
        if (this.m_bShipsHidden) {
            this.m_bShipsHidden = false;
            this.m_oPlMyShips.setAllBattleShipsVisible(true);
        }
        this.m_oPlEnemyShips.reset();
        this.m_oPlEnemyScore.reset();
        this.m_oPlMyScore.reset();
        this.setButtonLabelAndSize(this.m_oBtnReady, this.getString("Ready"), false);
        this.m_oTxtStatus.setBackground(Color.white);
        this.setButtonLabelAndSize(this.m_oBtnToggleHideShips, this.getString("HideShips"), true);
        this.m_oCntState.stop();
        if (this.m_oTmrGameOver != null) {
            this.m_oTmrGameOver.interrupt();
        }
        this.repaint();
    }

    private void stopConnect() {
        this.reset();
        if (this.m_connWithDedicatedServer) {
            this.m_oBspcParent.setWindowTitle("");
        }
        if (this.m_oSchSocket != null) {
            this.m_oSchSocket.interrupt();
        }
        this.m_oBtnReady.setEnabled(false);
        this.m_oTxtChatInput.setEnabled(false);
        this.m_oLblScore.setVisible(false);
        this.m_connWithDedicatedServer = false;
        this.m_showSelectEnemy = false;
        switch (this.m_mode) {
            case 1: {
                if (!this.m_bClientOnly) {
                    this.setButtonLabelAndSize(this.m_oBtnToggleConnect, this.getString("Connect"), false);
                }
                this.m_oBtnToggleConnect.repaint();
                this.m_bConnected = false;
                this.m_oCbClient.setEnabled(true);
                this.m_oCbServer.setEnabled(true);
                this.m_cbComputer.setEnabled(true);
                this.m_oTxtServer.setEnabled(true);
                this.m_txtPort.setEnabled(true);
                this.m_cntSelectEnemy.setVisible(false);
                this.m_btnSetPlayerName.setEnabled(false);
                this.m_txtPlayerName.setEnabled(true);
                this.m_playerName = "";
                this.m_enemyPlayerName = "";
                this.toggleConfirmation(null);
                this.m_btnDisconnectEnemy.setVisible(false);
                this.m_oLblEnemyShips.setText(this.getString("EnemyShips"), 1);
                break;
            }
            case 2: 
            case 3: {
                this.setButtonLabelAndSize(this.m_oBtnToggleServer, this.getString("ServerStart"), false);
                this.m_oBtnToggleServer.repaint();
                this.m_bServerRunning = false;
                this.m_oCbClient.setEnabled(true);
                this.m_oCbServer.setEnabled(true);
                this.m_cbComputer.setEnabled(true);
            }
        }
    }

    public void n_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        this.setReady();
    }

    private void setReady() {
        if (this.m_bPlaying) {
            if (!this.m_isBot || this.m_gameOver) {
                this.sendMessage("newgame", "1");
                this.reset();
                this.setStatus(this.getString("NewGame"));
            }
        } else {
            Point point;
            if (this.m_isBot) {
                this.m_Ai = new BattleShipsBotLogic(this.m_iFieldWidth, this.m_debug);
                this.m_Ai.setTestShipsPanel(this.m_plTestShips);
                this.m_Ai.setEnemyScorePanel(this.m_oPlEnemyScore);
                this.m_botPaused = false;
                this.refreshTimeOut();
            }
            if ((point = this.m_oPlMyShips.getShipsIntersectionPoint(true, false)) != null) {
                String string = MessageFormat.format(this.getString("ShipsIntersect"), this.getString("BattleShipType" + point.x), this.getString("BattleShipType" + point.y));
                this.setStatus(string);
            } else {
                String string = this.m_oPlMyShips.getShipInfo();
                this.sendMessage("shipinfo", this.m_oCryptUtil.encode(string));
                this.m_bPlaying = true;
                this.m_bMeReady = true;
                this.m_gameOver = false;
                if (this.m_bEnemyReady) {
                    this.m_oBtnReady.setEnabled(false);
                } else {
                    this.m_bMyTurn = true;
                }
                this.m_oBtnReady.setEnabled(false);
                this.setStatus(this.getString("Ready"));
                this.setTurn(true);
            }
        }
    }

    public void h_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        if (this.m_bShipsHidden) {
            this.m_bShipsHidden = false;
            this.m_oPlMyShips.setAllBattleShipsVisible(true);
            this.setButtonLabelAndSize(this.m_oBtnToggleHideShips, this.getString("HideShips"), true);
        } else {
            this.m_bShipsHidden = true;
            this.m_oPlMyShips.setAllBattleShipsVisible(false);
            this.setButtonLabelAndSize(this.m_oBtnToggleHideShips, this.getString("ShowShips"), true);
        }
    }

    public void t_ou(MouseEvent mouseEvent) {
        if (this.m_bClientOnly && mouseEvent.getModifiers() == 16 && !this.m_bConnected) {
            this.connect();
        }
    }

    public void l_ve(KeyEvent keyEvent) {
        String string;
        if (keyEvent.getKeyCode() == 10 && (string = this.m_oTxtChatInput.getText()).length() > 0) {
            this.m_oTxtChatInput.setText("");
            this.m_oTxtChatOutput.append(this.getString("You") + "> " + string + "\n");
            if (string.substring(0, 1).equals("/")) {
                this.sendMessage("servercommand", string);
            } else {
                this.sendMessage("chat", string);
            }
        }
    }

    public void ch_ou(MouseEvent mouseEvent) {
        if (!this.m_isBot || mouseEvent.getModifiers() != 16) {
            return;
        }
        if (this.m_botPaused) {
            this.m_botPaused = false;
            this.shootBot();
        } else {
            this.m_botPaused = true;
        }
    }

    public void r_ve(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.connect();
        }
    }

    public void pn_ve(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.setServerPlayerName();
        }
    }

    public void x_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        this.setMode(1, true);
    }

    public void y_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        this.setMode(2, true);
    }

    public void com_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        this.setMode(3, true);
    }

    private void setMode(int n, boolean bl) {
        this.m_mode = n;
        switch (n) {
            case 1: {
                this.m_oPnlClient.setVisible(true);
                this.m_oBtnToggleServer.setVisible(false);
                this.m_oCbRestoreWindow.setVisible(false);
                if (bl) break;
                this.m_oCbClient.setState(true);
                break;
            }
            case 2: {
                this.m_oPnlClient.setVisible(false);
                this.m_oBtnToggleServer.setVisible(true);
                this.m_oCbRestoreWindow.setVisible(true);
                if (bl) break;
                this.m_oCbServer.setState(true);
                break;
            }
            case 3: {
                this.m_oPnlClient.setVisible(false);
                this.m_oBtnToggleServer.setVisible(true);
                this.m_oCbRestoreWindow.setVisible(false);
                if (bl) break;
                this.m_cbComputer.setState(true);
            }
        }
        if (bl) {
            this.setCookie("Mode", Integer.toString(n));
        }
    }

    public void rw_omc(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        this.setCookie("RestoreWindow", this.m_oCbRestoreWindow.getState() ? "1" : "0");
    }

    public void i_b() {
        if (this.m_isBot) {
            if (this.m_autoBot) {
                this.setReady();
                this.m_botPaused = false;
                this.m_oPlMyShips.setShipsRandomPosition();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.m_botPaused) {
                    this.setReady();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.m_botPaused) {
                    this.shootBot();
                }
            }
        } else {
            if (this.m_bPlaySound) {
                this.playAudioClip(this.m_oAuGameOver);
            }
            this.m_oPlEnemyShips.showEnemyShips();
            this.m_oCntState.start();
        }
    }

    public void tu_b() {
        this.sendMessage("disconnectenemy", "");
    }

    public void g_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        if (this.m_bServerRunning) {
            if (this.m_mode == 3) {
                this.setStatus(this.getString("BotStopped"));
                if (this.m_botThread != null) {
                    this.m_botThread.interrupt();
                }
            } else {
                this.setStatus(this.getString("ServerStopped"));
            }
            this.stopConnect();
            if (this.m_oWebServer != null) {
                this.m_oWebServer.interrupt();
            }
        } else {
            this.setStatus(this.getString("ServerStarted"));
            this.startServer();
            if (this.m_bUseWebServer) {
                this.startWebServer();
            }
            if (!this.m_bClientOnly) {
                this.changeConfig(this.m_sOriginalConfig);
            }
            if (this.m_mode == 3) {
                this.m_botThread = new BotThread();
                this.m_botThread.start();
            }
        }
    }

    public void spn_ou(MouseEvent mouseEvent) {
        this.setServerPlayerName();
    }

    private synchronized void setServerPlayerName() {
        String string = this.m_txtPlayerName.getText();
        int n = this.m_txtPlayerName.getColumns();
        if (string.length() > n) {
            string = string.substring(0, n);
            this.m_txtPlayerName.setText(string);
        }
        if (!(string.equals("") || string.equals(this.m_playerName) && !this.m_playerName.equals(""))) {
            this.sendMessage("setplayername", string);
        }
    }

    public void se_ou(MouseEvent mouseEvent) {
        this.requestGame();
    }

    public void de_ou(MouseEvent mouseEvent) {
        if (this.m_bPlaying) {
            this.toggleConfirmation(MessageFormat.format(this.getString("ConfirmDisconnect"), this.m_enemyPlayerName));
        } else {
            this.sendMessage("disconnectenemy", "");
        }
    }

    private void startServer() {
        this.m_bHaveServerError = false;
        this.m_oSchSocket = new BattleShipsConnection(this);
        this.m_oSchSocket.setMessageQualifier("msg");
        this.m_oSchSocket.start(this.m_iServerPort);
        this.setButtonLabelAndSize(this.m_oBtnToggleServer, this.getString("ServerStop"), false);
        this.m_bServerRunning = true;
        this.m_oCbClient.setEnabled(false);
        this.m_oCbServer.setEnabled(false);
        this.m_cbComputer.setEnabled(false);
    }

    private void startWebServer() {
        if (this.m_bHaveServerError) {
            return;
        }
        String string = "";
        String string2 = this.getString("Error") + " Webserver: ";
        try {
            this.m_oWebServer = new WebServer(this.m_iWebServerPort, "BattleShips", "2.0", this.m_bWebServerLog);
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            string2 = string.indexOf("Address already in use") > -1 ? string2 + MessageFormat.format(this.getString("ServerPortInUse"), String.valueOf(this.m_iWebServerPort)) : string2 + string;
            this.appendStatus(string2);
        }
    }

    public void q_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        if (this.m_bConnected) {
            this.stopConnect();
            this.setStatus(this.getString("Disconnected"));
        } else {
            this.connect();
        }
    }

    public void j_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        this.m_oPlInfo.setVisible(true);
    }

    public void j_od(MouseEvent mouseEvent) {
        this.m_oPlInfo.setVisible(false);
    }

    public void k_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() != 16) {
            return;
        }
        this.m_bPlaySound = !this.m_bPlaySound;
        this.m_oBtnToggleSound.setOn(this.m_bPlaySound);
        this.setCookie("PlaySound", this.m_bPlaySound ? "1" : "0");
    }

    public void ok_ou(MouseEvent mouseEvent) {
        this.sendMessage("disconnectenemy", "");
    }

    public void cancel_ou(MouseEvent mouseEvent) {
        this.toggleConfirmation(null);
    }

    public void selE_odb(MouseEvent mouseEvent) {
        this.requestGame();
    }

    public void fps_ou(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 6) {
            this.m_connectToFirstPlayer = !this.m_connectToFirstPlayer;
            this.m_oTxtChatOutput.append("Internal> m_connectToFirstPlayer = " + this.m_connectToFirstPlayer + "\n");
        }
    }

    public void connect() {
        boolean bl;
        boolean bl2;
        block9: {
            bl2 = false;
            bl = false;
            String string = this.m_oTxtServer.getText();
            if (!string.equals("")) {
                try {
                    int n = Integer.parseInt(this.m_txtPort.getText());
                    if (n >= 1 && n <= 65535) {
                        this.setStatus(this.getString("Connecting"));
                        this.m_oSchSocket = new BattleShipsConnection(this);
                        this.m_oSchSocket.setMessageQualifier("msg");
                        this.m_oSchSocket.start(string, n);
                        if (!this.m_bClientOnly) {
                            this.setButtonLabelAndSize(this.m_oBtnToggleConnect, this.getString("Disconnect"), false);
                        }
                        this.m_bConnected = true;
                        this.m_oCbClient.setEnabled(false);
                        this.m_oCbServer.setEnabled(false);
                        this.m_cbComputer.setEnabled(false);
                        this.m_oTxtServer.setEnabled(false);
                        this.m_txtPort.setEnabled(false);
                        break block9;
                    }
                    bl2 = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = true;
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.socketError("General", this.getString("NoServer"));
        } else if (bl2) {
            this.socketError("General", this.getString("InvalidPort"));
        }
    }

    private void playAudioClip(AudioClipPath audioClipPath) {
        this.m_acpGameSounds.playAudioClip(audioClipPath);
    }

    private void setButtonLabelAndSize(GfxAnimatedButton gfxAnimatedButton, String string, boolean bl) {
        int n = gfxAnimatedButton.getLocation().x;
        int n2 = gfxAnimatedButton.getSize().width;
        int n3 = gfxAnimatedButton.getSize().height;
        gfxAnimatedButton.setLabel(string);
        gfxAnimatedButton.setSize(gfxAnimatedButton.getSize().width, n3);
        if (bl) {
            int n4 = n2 - gfxAnimatedButton.getSize().width;
            gfxAnimatedButton.setLocation(n + n4, gfxAnimatedButton.getLocation().y);
        }
    }

    private void requestGame() {
        int n = this.m_lstPlayerName.getSelectedIndex();
        if (n > -1 && this.m_lstPlayerName.getItemCount() > 0) {
            this.sendMessage("requestgame", this.m_lstPlayerName.getItem(n));
        }
    }

    private void print(String string) {
        System.out.println(string);
    }

    private class BotThread
    extends Thread {
        private BotThread() {
        }

        @Override
        public void run() {
            BattleShipsBot.main(new String[]{"-invisible", "-port", Integer.toString(BattleShipsPanel.this.m_botPort)});
        }
    }
}

