/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class BattleShipsServer
extends Thread
implements BattleShipsConnectionListener {
    private ServerSocketThread m_oServerSocketThread;
    private boolean m_bRunning;
    private Hashtable<String, BattleShipsConnection> m_oHtBattleShipsConnection;
    private Hashtable<String, String> m_oHtClientMapping;
    private String m_sCurrentConfig;
    private String m_sFreeSocketIdentifier;
    private boolean m_bUseWebServer;
    private int m_iWebServerPort;
    private WebServer m_oWebServer;
    private int m_iPort;
    private boolean m_bAllowRemoteAdmin;
    private String m_sRconPassword;
    private ArrayList<String> m_oVcLoggedIn;
    private BattleShipsUtility m_oUtil;
    private PrintWriter m_bwLog;
    private Hashtable<String, String> m_htPlayerName;
    private int m_currentDayOfYear;
    private final boolean DEBUG = false;

    public BattleShipsServer(PrintWriter printWriter, String string) {
        this.m_bwLog = printWriter;
        this.m_oUtil = new BattleShipsUtility();
        this.m_currentDayOfYear = 0;
        if (!string.equals("")) {
            this.m_oUtil.setServerConfigFile(string);
        }
        if (this.m_oUtil.readParameters()) {
            this.m_bAllowRemoteAdmin = this.m_oUtil.parseIntParm("AllowRemoteAdmin", 0) == 1;
            this.m_sRconPassword = this.m_oUtil.getParameter("RconPassword", "");
            this.m_iPort = this.m_oUtil.parseIntParm("ServerPort", 1000);
            if (this.m_iPort < 1 || this.m_iPort > 65535) {
                this.m_iPort = 1000;
            }
            int n = this.m_oUtil.parseIntParm("CellWidth", 10);
            int n2 = this.m_oUtil.parseIntParm("FieldWidth", 29);
            this.m_sCurrentConfig = n + ";" + n2;
            for (int i = 1; i <= 6; ++i) {
                int n3 = this.m_oUtil.parseIntParm("ShipTypeCount" + i, 1);
                this.m_sCurrentConfig = this.m_sCurrentConfig + ";" + n3;
            }
        } else {
            this.log(this.m_oUtil.getErrorMessage());
            System.exit(1);
        }
    }

    @Override
    public void start() {
        if (!this.m_bRunning) {
            try {
                this.m_oServerSocketThread = new ServerSocketThread(this, this.m_iPort);
                this.m_oHtBattleShipsConnection = new Hashtable();
                this.m_oHtClientMapping = new Hashtable();
                this.m_oVcLoggedIn = new ArrayList();
                this.m_htPlayerName = new Hashtable();
                this.m_sFreeSocketIdentifier = "";
                this.log(MessageFormat.format(this.getString("ServerStarting"), "2.0", Integer.toString(this.m_iPort)));
                this.log(this.getString("Configuration") + " " + this.m_sCurrentConfig);
                boolean bl = this.m_oUtil.parseIntParm("UseWebServer", 0) == 1;
                boolean bl2 = this.m_oUtil.parseIntParm("WebServerLog", 0) == 1;
                int n = this.m_oUtil.parseIntParm("WebServerPort", 80);
                if (n < 1 || n > 65535 || n == this.m_iPort) {
                    n = 80;
                }
                if (bl) {
                    this.startWebServer(n, bl2);
                }
            }
            catch (IOException iOException) {
                this.log(this.getString("Error") + " " + MessageFormat.format(this.getString("ServerPortInUse"), String.valueOf(this.m_iPort)));
                System.exit(1);
            }
            this.m_bRunning = true;
            super.start();
        }
    }

    @Override
    public void interrupt() {
        BattleShipsConnection battleShipsConnection = null;
        if (this.m_bRunning) {
            super.interrupt();
            this.m_bRunning = false;
            this.m_oServerSocketThread.interrupt();
            Enumeration<BattleShipsConnection> enumeration = this.m_oHtBattleShipsConnection.elements();
            while (enumeration.hasMoreElements()) {
                battleShipsConnection = enumeration.nextElement();
                battleShipsConnection.interrupt();
            }
            this.log(this.getString("ServerStopping"));
            if (this.m_oWebServer != null) {
                this.m_oWebServer.interrupt();
            }
        }
    }

    @Override
    public void run() {
    }

    public synchronized void clientConnected(Socket socket) {
        String string = socket.toString();
        this.log(this.getString("Connected2") + " " + string);
        BattleShipsConnection battleShipsConnection = new BattleShipsConnection(this, socket, string);
        this.m_htPlayerName.put(battleShipsConnection.getPlayerName(), string);
        battleShipsConnection.start();
        this.m_oHtBattleShipsConnection.put(string, battleShipsConnection);
    }

    @Override
    public void socketDataArrived(String string, String string2) {
    }

    @Override
    public synchronized void socketDataArrived(String string, String string2, String string3) {
        if (string.equals("disconnected")) {
            this.handleDisconnect(string3);
        } else if (string.equals("status")) {
            if (string2.equals("Connected")) {
                this.sendMessage("config", this.m_sCurrentConfig, string3);
                this.sendMessage("status", "Waiting", string3);
                this.broadcastClientList();
            }
        } else if (string.equals("servercommand")) {
            this.handleRemoteServerCommand(string2, string3);
        } else if (string.equals("setplayername")) {
            if (this.m_htPlayerName.containsKey(string2)) {
                this.sendMessage("playernameexists", string2, string3);
            } else {
                BattleShipsConnection battleShipsConnection = this.m_oHtBattleShipsConnection.get(string3);
                this.m_htPlayerName.remove(battleShipsConnection.getPlayerName());
                this.m_htPlayerName.put(string2, string3);
                battleShipsConnection.setPlayerName(string2);
                this.sendMessage("playernameset", string2, string3);
                this.broadcastClientList();
                this.log(this.getString("PlayerNameSet2") + " " + string3 + " - " + string2);
            }
        } else if (string.equals("requestgame")) {
            String string4 = this.m_htPlayerName.get(string2);
            if (string4 != null && !this.m_oHtClientMapping.containsKey(string3) && !this.m_oHtClientMapping.containsKey(string4)) {
                this.m_oHtClientMapping.put(string3, string4);
                this.m_oHtClientMapping.put(string4, string3);
                this.sendMessage("enemyfound", string2, string3);
                try {
                    BattleShipsServer.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BattleShipsConnection battleShipsConnection = this.m_oHtBattleShipsConnection.get(string3);
                this.sendMessage("enemyfound", battleShipsConnection.getPlayerName(), string4);
                this.broadcastClientList();
                this.log(this.getString("ClientsConnected") + " " + this.getPlayerNameById(string3) + " - " + string2);
            }
        } else if (string.equals("disconnectenemy")) {
            String string5 = this.m_oHtClientMapping.remove(string3);
            if (string5 != null) {
                this.m_oHtClientMapping.remove(string5);
                this.sendMessage("status", "EnemyLeft", string5);
                try {
                    BattleShipsServer.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.sendMessage("status", "EnemyLeft", string3);
                this.log(this.getString("ClientsDisconnected") + " " + this.getPlayerNameById(string3) + " - " + this.getPlayerNameById(string5));
            }
            this.broadcastClientList();
        } else if (string.equals("gameresult")) {
            String string6 = this.getPlayerNameById(string3);
            String string7 = this.m_oHtClientMapping.get(string3);
            String string8 = this.getPlayerNameById(string7);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            this.log(this.getString("GameResult") + " " + string6 + " - " + string8 + ": " + stringTokenizer.nextToken() + " - " + stringTokenizer.nextToken());
        } else {
            String string9;
            if (string.equals("chat")) {
                this.log(string3 + ": " + string2);
            }
            if ((string9 = this.m_oHtClientMapping.get(string3)) != null) {
                this.sendMessage(string, string2, string9);
            }
        }
    }

    public void printClientList() {
        this.log(this.getString("ClientList") + "\n" + this.getClientList("", false));
    }

    public String getHelpMsg() {
        return "================\n" + MessageFormat.format(this.getString("ServerHelpMsg"), "\n") + "\n================";
    }

    public String kickPlayer(String string) {
        String string2;
        if (this.m_htPlayerName.containsKey(string)) {
            String string3 = this.m_htPlayerName.get(string);
            string2 = this.handleDisconnect(string3);
        } else {
            string2 = this.getString("NoSuchPlayer");
            this.log(string2);
        }
        return string2;
    }

    @Override
    public synchronized void socketError(String string, String string2, String string3) {
        this.handleDisconnect(string3);
    }

    @Override
    public void socketError(String string, String string2) {
    }

    private String handleDisconnect(String string) {
        String string2;
        BattleShipsConnection battleShipsConnection = this.m_oHtBattleShipsConnection.remove(string);
        String string3 = battleShipsConnection.getPlayerName();
        if (this.m_htPlayerName.containsKey(string3)) {
            this.m_htPlayerName.remove(string3);
        }
        if (this.m_oVcLoggedIn.contains(string)) {
            this.m_oVcLoggedIn.remove(string);
        }
        if (string.equals(this.m_sFreeSocketIdentifier)) {
            this.m_sFreeSocketIdentifier = "";
        }
        if ((string2 = this.m_oHtClientMapping.remove(string)) != null) {
            this.m_oHtClientMapping.remove(string2);
            this.sendMessage("status", "EnemyLeft", string2);
        }
        battleShipsConnection.interrupt();
        this.broadcastClientList();
        String string4 = this.getString("Disconnected2") + " " + string + " (" + string3 + ")";
        this.log(string4);
        return string4;
    }

    private void handleRemoteServerCommand(String string, String string2) {
        char[] cArray;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (this.m_bAllowRemoteAdmin && string.length() > 1 && string.substring(0, 1).equals("/") && ((cArray = (string3 = string.substring(1)).toCharArray())[0] == 'l' || cArray[0] == 'x' || this.m_oVcLoggedIn.contains(string2))) {
            if (string.length() > 3) {
                string4 = string.substring(3);
            }
            switch (cArray[0]) {
                case 'c': {
                    string5 = this.getString("ClientList") + "\n" + this.getClientList(string2, false);
                    break;
                }
                case 'k': {
                    if (string4.equals("") || cArray[1] != ' ') {
                        string5 = this.getString("EnterPlayerName");
                        break;
                    }
                    string5 = this.kickPlayer(string4);
                    break;
                }
                case 'h': {
                    string5 = "================\n" + MessageFormat.format(this.getString("RemoteHelpMsg"), "\n") + "\n================";
                    break;
                }
                case 'l': {
                    if (this.m_oVcLoggedIn.contains(string2)) {
                        string5 = this.getString("AlreadyLoggedIn");
                        break;
                    }
                    if (string4.equals(this.m_sRconPassword)) {
                        this.m_oVcLoggedIn.add(string2);
                        string5 = this.getString("LoggedIn");
                        break;
                    }
                    string5 = this.getString("WrongPassword");
                    break;
                }
                case 'x': {
                    if (this.m_oVcLoggedIn.contains(string2)) {
                        this.m_oVcLoggedIn.remove(string2);
                        string5 = this.getString("LoggedOut");
                        break;
                    }
                    string5 = this.getString("NotLoggedIn");
                    break;
                }
                default: {
                    string5 = this.getString("UnknownCommand");
                }
            }
            this.sendMessage("serverresponse", string5, string2);
        }
    }

    private String getClientList(String string, boolean bl) {
        String string2 = "";
        if (this.m_htPlayerName.isEmpty()) {
            if (!bl) {
                string2 = this.getString("NoClientsConnected");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration<String> enumeration = this.m_htPlayerName.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                String string4 = this.m_htPlayerName.get(string3);
                if (bl) {
                    if (this.m_oHtClientMapping.containsKey(string4) || string4.equals(string)) continue;
                    stringBuffer.append(string3);
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append(string4);
                stringBuffer.append(" (");
                stringBuffer.append(string3);
                stringBuffer.append(")");
                if (string4.equals(string)) {
                    stringBuffer.append(" (" + this.getString("You") + ")");
                }
                stringBuffer.append("\n");
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private void broadcastClientList() {
        Enumeration<String> enumeration = this.m_oHtBattleShipsConnection.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (this.m_oHtClientMapping.containsKey(string)) continue;
            this.sendMessage("clientlistupdate", this.getClientList(string, true), string);
        }
    }

    private void sendMessage(String string, String string2, String string3) {
        BattleShipsConnection battleShipsConnection = this.m_oHtBattleShipsConnection.get(string3);
        if (battleShipsConnection != null) {
            battleShipsConnection.sendMessage(string, string2);
        }
    }

    private void startWebServer(int n, boolean bl) {
        String string = "";
        String string2 = this.getString("Error") + " Webserver: ";
        try {
            this.m_oWebServer = new WebServer(n, "BattleShips", "2.0", bl);
            this.log(MessageFormat.format(this.getString("WebServerStarting"), String.valueOf(n)));
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            string2 = string.indexOf("Address already in use") > -1 ? string2 + MessageFormat.format(this.getString("ServerPortInUse"), String.valueOf(n)) : string2 + string;
            this.log(string2);
        }
    }

    private void log(String string) {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(6);
        if (this.m_currentDayOfYear != n) {
            this.m_bwLog.println(BattleShipsUtility.getTimeStamp(calendar) + " - " + new Date().toString());
            this.m_currentDayOfYear = n;
        }
        this.m_bwLog.println(BattleShipsUtility.getTimeStamp(calendar) + " - " + string);
    }

    private void sendLogToAdmins(String string) {
        if (this.m_oVcLoggedIn != null && !this.m_oVcLoggedIn.isEmpty()) {
            ListIterator<String> listIterator = this.m_oVcLoggedIn.listIterator();
            while (listIterator.hasNext()) {
                String string2 = listIterator.next();
                this.sendMessage("serverresponse", string, string2);
                System.out.println("Sending msg to " + string2);
            }
        }
    }

    public String getPlayerNameById(String string) {
        BattleShipsConnection battleShipsConnection = this.m_oHtBattleShipsConnection.get(string);
        return battleShipsConnection.getPlayerName();
    }

    public String getString(String string) {
        return this.m_oUtil.getParameter("String_" + string);
    }
}

