/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.Hashtable;

public class BattleShipsUtility {
    public static final String VERSION = "2.0";
    public static final int MAX_SHIP_TYPE = 6;
    public static final int MODE_CLIENT = 1;
    public static final int MODE_SERVER = 2;
    public static final int MODE_COMPUTER = 3;
    public static final int DEFAULT_PORT = 666;
    private static final String CONFIG_FILE = "config.htm";
    private static final String SERVER_CONFIG_FILE = "server.cfg";
    private String m_sErrorMessage;
    private Hashtable<String, String> m_oHtParameters = new Hashtable();
    private String m_serverConfigFile = "server.cfg";

    public boolean readParameters() {
        boolean bl = this.readParameters(CONFIG_FILE);
        if (bl) {
            bl = this.readParameters(this.m_serverConfigFile);
        }
        return bl;
    }

    public void setServerConfigFile(String string) {
        this.m_serverConfigFile = string;
    }

    private boolean readParameters(String string) {
        boolean bl = true;
        try {
            String string2 = "";
            BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(new FileInputStream(string), null));
            int n = -1;
            String string3 = "";
            String string4 = "";
            while (string2 != null) {
                string2 = bufferedReader.readLine();
                if (string2 == null || (n = string2.toLowerCase().indexOf("<param")) <= -1) continue;
                n = string2.toLowerCase().indexOf("name=\"", n + 6);
                string3 = string2.substring(n + 6, string2.indexOf("\"", n + 6));
                n = string2.toLowerCase().indexOf("value=\"", n + 6);
                string4 = string2.substring(n + 7, string2.indexOf("\"", n + 7));
                this.m_oHtParameters.put(string3, string4);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_sErrorMessage = "Error: File '" + string + "' not found. It must be in the same folder like the application files.";
            bl = false;
        }
        catch (Exception exception) {
            this.m_sErrorMessage = "Error: " + exception.toString();
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public String getParameter(String string) {
        return this.m_oHtParameters.get(string);
    }

    public int parseIntParm(String string, int n) {
        string = this.getParameter(string);
        int n2 = n;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public static String getZeroed(int n) {
        String string = "00" + n;
        string = string.substring(string.length() - 2, string.length());
        return string;
    }

    public static String getCopyright() {
        return "Schiffe Versenken (Battleships) V2.0\n\u00a9 2005-2022 Stan Holoubek\nhttp://www.stans-world.de/battleships.html";
    }

    public static String getTimeStamp(Calendar calendar) {
        String string = BattleShipsUtility.getZeroed(calendar.get(11)) + ":" + BattleShipsUtility.getZeroed(calendar.get(12)) + ":" + BattleShipsUtility.getZeroed(calendar.get(13));
        return string;
    }
}

