/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class CliArgs {
    private String[] args = null;
    private HashMap<String, Integer> switchIndexes = new HashMap();
    private TreeSet<Integer> takenIndexes = new TreeSet();
    private List<String> targets = new ArrayList<String>();

    public CliArgs(String[] stringArray) {
        this.parse(stringArray);
    }

    public void parse(String[] stringArray) {
        this.args = stringArray;
        this.switchIndexes.clear();
        this.takenIndexes.clear();
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].startsWith("-")) continue;
            this.switchIndexes.put(this.args[i], i);
            this.takenIndexes.add(i);
        }
    }

    public String[] args() {
        return this.args;
    }

    public String arg(int n) {
        return this.args[n];
    }

    public boolean switchPresent(String string) {
        return this.switchIndexes.containsKey(string);
    }

    public String switchValue(String string) {
        return this.switchValue(string, null);
    }

    public String switchValue(String string, String string2) {
        if (!this.switchIndexes.containsKey(string)) {
            return string2;
        }
        int n = this.switchIndexes.get(string);
        if (n + 1 < this.args.length) {
            this.takenIndexes.add(n + 1);
            return this.args[n + 1];
        }
        return string2;
    }

    public int switchIntValue(String string) {
        return this.switchIntValue(string, 0);
    }

    public int switchIntValue(String string, int n) {
        String string2 = this.switchValue(string, null);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public Long switchLongValue(String string) {
        return this.switchLongValue(string, null);
    }

    public Long switchLongValue(String string, Long l) {
        String string2 = this.switchValue(string, null);
        if (string2 == null) {
            return l;
        }
        return Long.parseLong(string2);
    }

    public Double switchDoubleValue(String string) {
        return this.switchDoubleValue(string, null);
    }

    public Double switchDoubleValue(String string, Double d) {
        String string2 = this.switchValue(string, null);
        if (string2 == null) {
            return d;
        }
        return Double.parseDouble(string2);
    }

    public String[] switchValues(String string) {
        int n;
        if (!this.switchIndexes.containsKey(string)) {
            return new String[0];
        }
        int n2 = this.switchIndexes.get(string);
        for (n = n2 + 1; n < this.args.length && !this.args[n].startsWith("-"); ++n) {
            this.takenIndexes.add(n);
        }
        String[] stringArray = new String[n - n2 - 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.args[n2 + i + 1];
        }
        return stringArray;
    }

    public <T> T switchPojo(Class<T> clazz) {
        try {
            Field[] fieldArray;
            T t = clazz.newInstance();
            for (Field field : fieldArray = clazz.getFields()) {
                String[] stringArray;
                Class<?> clazz2 = field.getType();
                String string = "-" + field.getName().replace('_', '-');
                if (clazz2.equals(Boolean.class) || clazz2.equals(Boolean.TYPE)) {
                    field.set(t, this.switchPresent(string));
                    continue;
                }
                if (clazz2.equals(String.class)) {
                    if (this.switchValue(string) == null) continue;
                    field.set(t, this.switchValue(string));
                    continue;
                }
                if (clazz2.equals(Long.class) || clazz2.equals(Long.TYPE)) {
                    if (this.switchLongValue(string) == null) continue;
                    field.set(t, this.switchLongValue(string));
                    continue;
                }
                if (clazz2.equals(Integer.class) || clazz2.equals(Integer.TYPE)) {
                    if (this.switchLongValue(string) == null) continue;
                    field.set(t, this.switchLongValue(string).intValue());
                    continue;
                }
                if (clazz2.equals(Short.class) || clazz2.equals(Short.TYPE)) {
                    if (this.switchLongValue(string) == null) continue;
                    field.set(t, this.switchLongValue(string).shortValue());
                    continue;
                }
                if (clazz2.equals(Byte.class) || clazz2.equals(Byte.TYPE)) {
                    if (this.switchLongValue(string) == null) continue;
                    field.set(t, this.switchLongValue(string).byteValue());
                    continue;
                }
                if (clazz2.equals(Double.class) || clazz2.equals(Double.TYPE)) {
                    if (this.switchDoubleValue(string) == null) continue;
                    field.set(t, this.switchDoubleValue(string));
                    continue;
                }
                if (clazz2.equals(Float.class) || clazz2.equals(Float.TYPE)) {
                    if (this.switchDoubleValue(string) == null) continue;
                    field.set(t, Float.valueOf(this.switchDoubleValue(string).floatValue()));
                    continue;
                }
                if (!clazz2.equals(String[].class) || (stringArray = this.switchValues(string)).length == 0) continue;
                field.set(t, stringArray);
            }
            return t;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error creating switch POJO", exception);
        }
    }

    public String[] targets() {
        String[] stringArray = new String[this.args.length - this.takenIndexes.size()];
        int n = 0;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.takenIndexes.contains(i)) continue;
            stringArray[n++] = this.args[i];
        }
        return stringArray;
    }
}

