/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GfxAnimatedButton
extends Container {
    private Object m_oOwner;
    private String m_sName;
    private boolean m_bIsRollover;
    private Image m_oImgOn;
    private Image m_oImgOff;
    private Image m_oImgImage;
    private TextDisplayPanel m_oPnlText;
    private boolean m_bTextPositioned;
    private boolean m_bPressed;
    private int m_iPressedOffsetX;
    private int m_iPressedOffsetY;
    private boolean m_bEnabled;
    private static int MIN_WIDTH = 50;
    private FontMetrics m_fntMetrics;

    public GfxAnimatedButton(Object object, String string, Image image, Image image2) {
        this.m_oOwner = object;
        this.m_sName = string;
        this.m_bIsRollover = image2 != null;
        this.m_oImgOn = image;
        this.m_oImgOn.getWidth(this);
        this.m_oImgOff = image2;
        this.m_oImgOff.getWidth(this);
        this.m_oImgImage = this.m_oImgOff;
        this.m_bTextPositioned = true;
        this.m_bPressed = false;
        this.m_bEnabled = true;
        this.m_iPressedOffsetX = 1;
        this.m_iPressedOffsetY = 1;
        this.setForeground(new Color(0, 34, 136));
        this.setCursor(new Cursor(12));
        this.addMouseListener(new TheMouseAdapter(this, "b"));
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintContent(graphics);
        super.paint(graphics);
    }

    private void paintContent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.m_oImgImage != null) {
            graphics.drawImage(this.m_oImgImage, 0, 0, this);
            graphics.setColor(new Color(187, 187, 187));
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
        if (!this.m_bTextPositioned && this.m_oPnlText.getBounds().width > 1) {
            int n = this.m_oPnlText.getBounds().width;
            int n2 = this.m_oPnlText.getBounds().height;
            int n3 = Math.round((this.getBounds().width - n) / 2);
            int n4 = Math.round((this.getBounds().height - n2) / 2);
            this.m_oPnlText.setLocation(n3 += this.m_bPressed ? this.m_iPressedOffsetX : 0, n4 += this.m_bPressed ? this.m_iPressedOffsetY : 0);
            this.m_bTextPositioned = true;
        }
    }

    public void setLabel(String string) {
        if (this.m_oPnlText == null) {
            this.m_oPnlText = (TextDisplayPanel)this.add(new TextDisplayPanel());
            this.m_oPnlText.setFont(this.getFont());
            this.m_oPnlText.setForeground(this.getForeground());
        }
        this.m_oPnlText.setText(string, 1);
        this.m_bTextPositioned = false;
        if (this.m_fntMetrics != null) {
            this.setSize(this.m_fntMetrics.stringWidth(this.getLabel()) + 15, this.m_fntMetrics.getHeight() + 8);
        }
    }

    public String getLabel() {
        return this.m_oPnlText.getText();
    }

    @Override
    public void setSize(int n, int n2) {
        if (n < MIN_WIDTH) {
            n = MIN_WIDTH;
        }
        super.setSize(n, n2);
        this.m_bTextPositioned = false;
        this.paintContent(this.getGraphics());
    }

    @Override
    public void setFont(Font font) {
        this.m_fntMetrics = this.getFontMetrics(font);
        super.setFont(font);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_bEnabled = bl;
        if (bl) {
            this.setCursor(new Cursor(12));
            this.m_oPnlText.setForeground(this.getForeground());
        } else {
            this.m_oImgImage = this.m_oImgOff;
            this.setCursor(new Cursor(0));
            this.m_oPnlText.setForeground(new Color(160, 160, 160));
        }
        this.repaint();
    }

    public void b_oi(MouseEvent mouseEvent) {
        if (this.m_bEnabled && mouseEvent.getModifiers() == 16 && this.m_bIsRollover) {
            this.m_oImgImage = this.m_oImgOn;
            if (this.m_oPnlText != null) {
                this.m_bTextPositioned = false;
                this.m_bPressed = true;
            }
            this.paintContent(this.getGraphics());
        }
    }

    public void b_od(MouseEvent mouseEvent) {
        if (this.m_bPressed) {
            this.click(mouseEvent, false, true);
        }
    }

    public void b_ok(MouseEvent mouseEvent) {
        if (this.m_bPressed) {
            this.click(mouseEvent, false, false);
        }
    }

    public void b_ou(MouseEvent mouseEvent) {
        this.click(mouseEvent, true, false);
    }

    private void click(MouseEvent mouseEvent, boolean bl, boolean bl2) {
        if (this.m_bEnabled && (mouseEvent.getModifiers() == 16 || bl2)) {
            if (this.m_bIsRollover) {
                this.m_oImgImage = this.m_oImgOff;
                if (this.m_oPnlText != null) {
                    this.m_bTextPositioned = false;
                    this.m_bPressed = false;
                }
                this.paintContent(this.getGraphics());
            }
            if (bl) {
                Class<?> clazz = this.m_oOwner.getClass();
                try {
                    Method method = clazz.getMethod(this.m_sName + "_ou", mouseEvent.getClass());
                    try {
                        method.invoke(this.m_oOwner, mouseEvent);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.getTargetException().printStackTrace();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }
}

