/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpRequestThread
extends Thread {
    private File m_oRootDir;
    private Socket m_oSocket;
    private String m_sAppName;
    private String m_sAppVersion;
    private PrintWriter m_oLogPrintWriter;
    private boolean m_bLog;

    public HttpRequestThread(Socket socket, File file, String string, String string2, PrintWriter printWriter) {
        this.m_oSocket = socket;
        this.m_oRootDir = file;
        this.m_sAppName = string;
        this.m_sAppVersion = string2;
        this.m_oLogPrintWriter = printWriter;
        this.m_bLog = this.m_oLogPrintWriter != null;
    }

    @Override
    public void run() {
        block37: {
            BufferedInputStream bufferedInputStream = null;
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            int n = 0;
            int n2 = 0;
            Object object = null;
            try {
                String string5 = this.m_oSocket.getInetAddress().getHostAddress();
                this.m_oSocket.setSoTimeout(30000);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_oSocket.getInputStream()));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.m_oSocket.getOutputStream());
                String string6 = bufferedReader.readLine();
                try {
                    while (bufferedReader.ready()) {
                        String string7 = bufferedReader.readLine();
                        if (string7.toLowerCase().indexOf("referer:") > -1) {
                            string2 = this.getHeader(string7);
                            ++n;
                        } else if (string7.toLowerCase().indexOf("host:") > -1) {
                            string4 = this.getHeader(string7);
                            ++n;
                        }
                        if (n != 2) continue;
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (string6 == null || !string6.endsWith("HTTP/1.0") && !string6.endsWith("HTTP/1.1")) {
                    this.sendError(bufferedOutputStream, "400 Bad Request", "Bad Request");
                    n2 = 400;
                } else if (!string6.startsWith("GET ")) {
                    this.sendError(bufferedOutputStream, "501 Not Implemented", "Method Not Implemented");
                    n2 = 501;
                } else {
                    String string8 = string6.substring(4, string6.length() - 9);
                    try {
                        string = URLDecoder.decode(string8, "UTF-8");
                    }
                    catch (Exception exception) {
                        this.sendError(bufferedOutputStream, "404 Not Found", "File Not Found");
                        n2 = 404;
                    }
                    if (n2 == 0) {
                        Object object2;
                        Object object3;
                        int n3 = string.indexOf("?");
                        if (n3 > -1) {
                            string3 = string.substring(n3);
                            string = string.substring(0, n3);
                        }
                        if (string.length() > 8 && string.substring(0, 8).equals("/resolve") && !string4.equals("")) {
                            try {
                                object3 = "";
                                object2 = string.substring(8);
                                n3 = string4.indexOf(":");
                                if (n3 > -1) {
                                    object3 = string4.substring(n3 + 1);
                                    string4 = string4.substring(0, n3);
                                }
                                InetAddress inetAddress = InetAddress.getByName(string4);
                                string4 = inetAddress.getHostAddress();
                                if (!((String)object3).equals("")) {
                                    string4 = string4 + ":" + (String)object3;
                                }
                                this.sendRedirect(bufferedOutputStream, "http://" + string4 + (String)object2 + string3);
                                n2 = 302;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (n2 == 0) {
                            object = new File(new File(this.m_oRootDir, string).getCanonicalPath());
                            if (!((File)object).toString().startsWith(this.m_oRootDir.toString())) {
                                this.sendError(bufferedOutputStream, "403 Forbidden", "Forbidden");
                                n2 = 403;
                            } else if (((File)object).isDirectory()) {
                                object3 = new File((File)object, "default.htm");
                                if (!((File)object3).exists() || ((File)object3).isDirectory()) {
                                    this.sendError(bufferedOutputStream, "403 Forbidden", "Directory Listing Denied");
                                    n2 = 403;
                                } else {
                                    object = object3;
                                }
                            } else if (!((File)object).exists()) {
                                this.sendError(bufferedOutputStream, "404 Not Found", "File Not Found");
                                n2 = 404;
                            }
                        }
                        if (n2 == 0) {
                            object3 = WebServer.getMimeType(object);
                            if (((String)object3).equals("forbidden")) {
                                this.sendError(bufferedOutputStream, "403 Forbidden", "Forbidden");
                                n2 = 403;
                            } else {
                                int n4;
                                bufferedInputStream = new BufferedInputStream(new FileInputStream((File)object));
                                this.sendHeader(bufferedOutputStream, "200 OK", (String)object3, ((File)object).length(), ((File)object).lastModified());
                                n2 = 200;
                                object2 = new byte[4096];
                                while ((n4 = bufferedInputStream.read((byte[])object2)) != -1) {
                                    bufferedOutputStream.write((byte[])object2, 0, n4);
                                }
                                bufferedInputStream.close();
                                bufferedOutputStream.flush();
                                bufferedOutputStream.close();
                            }
                        }
                    }
                }
                if (this.m_bLog) {
                    this.log(n2, string5, string6, string2);
                }
            }
            catch (IOException iOException) {
                if (bufferedInputStream == null) break block37;
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private String getHeader(String string) {
        return string.substring(string.indexOf(":") + 2);
    }

    private void sendError(BufferedOutputStream bufferedOutputStream, String string, String string2) throws IOException {
        string2 = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><HTML><HEAD><TITLE>" + string + "</TITLE></HEAD><BODY><H1>" + string2 + "</H1><HR><ADDRESS>" + this.m_sAppName + "/" + this.m_sAppVersion + "</ADDRESS></BODY></HTML>";
        this.sendHeader(bufferedOutputStream, string, "text/html", string2.length(), System.currentTimeMillis());
        bufferedOutputStream.write(string2.getBytes());
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private void sendRedirect(BufferedOutputStream bufferedOutputStream, String string) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Location", string);
        String string2 = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><HTML><HEAD><TITLE>Object moved</TITLE></HEAD><BODY><H1>Object Moved</H1>This object may be found <A HREF=\"" + string + "\">here</A>.</BODY></HTML>";
        this.sendHeader(bufferedOutputStream, "302 Object moved", "text/html", string2.length(), System.currentTimeMillis(), hashtable);
        bufferedOutputStream.write(string2.getBytes());
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private void sendHeader(BufferedOutputStream bufferedOutputStream, String string, String string2, long l, long l2, Hashtable hashtable) throws IOException {
        String string3 = "";
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                string3 = string3 + "\r\n" + k.toString() + ": " + hashtable.get(k).toString();
            }
        }
        bufferedOutputStream.write(("HTTP/1.0 " + string + "\r\nServer: " + this.m_sAppName + "/" + this.m_sAppVersion + "\r\nDate: " + WebServer.getHttpDate(new Date()) + "\r\nContent-Type: " + string2 + "\r\nLast-Modified: " + WebServer.getHttpDate(new Date(l2)) + string3 + "\r\nContent-Length: " + l + "\r\n\r\n").getBytes());
    }

    private void sendHeader(BufferedOutputStream bufferedOutputStream, String string, String string2, long l, long l2) throws IOException {
        this.sendHeader(bufferedOutputStream, string, string2, l, l2, null);
    }

    private void log(int n, String string, String string2, String string3) {
        Calendar calendar = Calendar.getInstance();
        this.m_oLogPrintWriter.println(BattleShipsUtility.getTimeStamp(calendar) + " " + n + " " + string + " " + string2 + " " + string3);
        this.m_oLogPrintWriter.flush();
    }
}

