/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class StateDisplayPanel
extends Container {
    private String m_sText;
    private boolean m_bResize;
    private TheTimerTask m_oTmrSwitch;
    private int m_iSwitchCount;
    private final int MAX_SWITCH_COUNT = 10;

    public StateDisplayPanel() {
        this.setLayout(null);
        this.m_sText = "";
        this.m_bResize = true;
        this.addMouseListener(new TheMouseAdapter(this, "c"));
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
        try {
            Graphics2DFactory.setAntialiasing(graphics);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.m_sText.equals("")) {
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getAscent();
            if (this.m_bResize) {
                int n2 = fontMetrics.stringWidth(this.m_sText) + Math.round(fontMetrics.getMaxAdvance() / 2);
                int n3 = fontMetrics.getHeight();
                Dimension dimension2 = this.getParent().getSize();
                this.setBounds(Math.round((dimension2.width - n2) / 2), Math.round((dimension2.height - n3) / 3), n2, n3);
            }
            graphics.drawString(this.m_sText, Math.round(fontMetrics.getMaxAdvance() / 4), n);
            graphics.drawRect(0, 0, this.getBounds().width - 1, this.getBounds().height - 1);
            graphics.drawRect(1, 1, this.getBounds().width - 3, this.getBounds().height - 3);
            graphics.drawRect(2, 2, this.getBounds().width - 5, this.getBounds().height - 5);
        }
        super.paint(graphics);
    }

    public void setText(String string) {
        this.m_sText = string;
        this.m_bResize = true;
        this.repaint();
    }

    public void refreshSize() {
        this.m_bResize = true;
        this.repaint();
    }

    public void start() {
        this.m_iSwitchCount = 0;
        this.setVisible(true);
        this.refreshSize();
        this.m_oTmrSwitch = new TheTimerTask(this, "k");
        this.m_oTmrSwitch.start(300L, 300L);
    }

    public void stop() {
        if (this.m_oTmrSwitch != null) {
            this.m_oTmrSwitch.interrupt();
        }
        this.setVisible(false);
    }

    public void k_b() {
        ++this.m_iSwitchCount;
        if (this.m_iSwitchCount == 10) {
            this.m_oTmrSwitch.interrupt();
            this.setVisible(true);
        } else {
            this.setVisible(!this.isVisible());
        }
    }

    public void c_oh(MouseEvent mouseEvent) {
        if (this.m_iSwitchCount == 10) {
            this.setVisible(false);
        }
    }
}

