/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class TextDisplayPanel
extends Container {
    private String m_sText;
    private String m_sSplitText;
    private int m_iResizeFlagText;
    private int m_iPadding;
    private Color m_oColBackground;
    private boolean m_bWithGraphics2D;
    private boolean m_bWithBorder;
    public static final int MANUAL_RESIZE = 0;
    public static final int AUTO_RESIZE = 1;

    public TextDisplayPanel() {
        this.setLayout(null);
        this.m_sText = "";
        this.m_sSplitText = " ";
        this.m_iPadding = 1;
        this.m_bWithGraphics2D = true;
        this.m_bWithBorder = false;
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintContent(graphics);
        super.paint(graphics);
    }

    @Override
    public void setBackground(Color color) {
        this.m_oColBackground = color;
    }

    public void setBounds(int n, int n2) {
        this.setBounds(n, n2, 1, 1);
    }

    public String getSplitText() {
        return this.m_sSplitText;
    }

    public void setSplitText(String string) {
        this.m_sSplitText = string;
    }

    public void setPadding(int n) {
        this.m_iPadding = n;
    }

    public String getText() {
        return this.m_sText;
    }

    public void setText(String string, int n) {
        this.m_sText = string;
        this.m_iResizeFlagText = n;
        this.paintContent(this.getGraphics());
    }

    public void setText(String string) {
        this.setText(string, 0);
    }

    public void append(String string) {
        this.m_sText = this.m_sText + string;
        this.paintContent(this.getGraphics());
    }

    public void setWithBorder(boolean bl) {
        this.m_bWithBorder = bl;
    }

    public void setWithGraphics2D(boolean bl) {
        this.m_bWithGraphics2D = bl;
    }

    private void paintContent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.m_oColBackground != null) {
            graphics.setColor(this.m_oColBackground);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        graphics.setColor(this.getForeground());
        if (this.m_bWithBorder) {
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
        if (this.m_bWithGraphics2D) {
            try {
                Graphics2DFactory.setAntialiasing(graphics);
            }
            catch (Throwable throwable) {
                this.m_bWithGraphics2D = false;
            }
        }
        if (!this.m_sText.equals("")) {
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = (int)Math.round((double)fontMetrics.getHeight() / 1.5) + 1;
            int n2 = this.getSize().width;
            if (this.m_iResizeFlagText == 1) {
                this.m_iResizeFlagText = 0;
                this.setSize(fontMetrics.stringWidth(this.m_sText) + 4, fontMetrics.getHeight() + 1);
                graphics.drawString(this.m_sText, 1 + this.m_iPadding, n + this.m_iPadding);
            } else if (fontMetrics.stringWidth(this.m_sText) > n2 - this.m_iPadding * 2 || this.m_sText.indexOf("\n") > -1) {
                if (n2 == 0) {
                    return;
                }
                int n3 = n;
                StringBuffer stringBuffer = new StringBuffer();
                StringTokenizer stringTokenizer = new StringTokenizer(this.m_sText, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string, this.m_sSplitText);
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string2 = stringTokenizer2.nextToken();
                        if (fontMetrics.stringWidth(stringBuffer.toString()) + fontMetrics.stringWidth(this.m_sSplitText) + fontMetrics.stringWidth(string2) > n2 - this.m_iPadding * 2) {
                            graphics.drawString(stringBuffer.toString(), 1 + this.m_iPadding, n3 + this.m_iPadding);
                            stringBuffer.setLength(0);
                            n3 += n + 3;
                        } else if (stringBuffer.length() > 0) {
                            stringBuffer.append(this.m_sSplitText);
                        }
                        stringBuffer.append(string2);
                    }
                    graphics.drawString(stringBuffer.toString(), 1 + this.m_iPadding, n3 + this.m_iPadding);
                    stringBuffer.setLength(0);
                    n3 += n + 3;
                }
            } else {
                graphics.drawString(this.m_sText, 1 + this.m_iPadding, n + this.m_iPadding);
            }
        }
    }
}

