/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public class WebServer
extends Thread {
    private File m_oRootDir = new File(new File("./").getCanonicalPath());
    private ServerSocket m_oServerSocket;
    private boolean m_bRunning;
    private String m_sAppName;
    private String m_sAppVersion;
    private PrintWriter m_oLogPrintWriter;
    private boolean m_log;
    private int m_dayOfMonth;
    private final boolean DEBUG = false;
    private static final Hashtable<String, String> MIME_TYPES = new Hashtable();

    public WebServer(int n, String string, String string2, boolean bl) throws IOException {
        this.m_oServerSocket = new ServerSocket(n);
        this.m_sAppName = string;
        this.m_sAppVersion = string2;
        this.m_log = bl;
        if (this.m_log) {
            this.openLogPrintWriter();
        }
        this.start();
    }

    @Override
    public void start() {
        if (!this.m_bRunning) {
            this.m_bRunning = true;
            super.start();
        }
    }

    @Override
    public void interrupt() {
        if (this.m_bRunning) {
            super.interrupt();
            this.m_bRunning = false;
            try {
                this.m_oServerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.m_log) {
                this.closeLogPrintWriter();
            }
        }
    }

    @Override
    public void run() {
        while (this.m_bRunning) {
            try {
                Object object;
                Socket socket = this.m_oServerSocket.accept();
                if (this.m_log && ((Calendar)(object = Calendar.getInstance())).get(5) != this.m_dayOfMonth) {
                    this.closeLogPrintWriter();
                    this.openLogPrintWriter();
                }
                object = new HttpRequestThread(socket, this.m_oRootDir, this.m_sAppName, this.m_sAppVersion, this.m_oLogPrintWriter);
                ((Thread)object).start();
            }
            catch (Exception exception) {}
        }
    }

    public static String getMimeType(File file) {
        String string = MIME_TYPES.get(WebServer.getExtension(file));
        if (string == null) {
            string = "application/octet-stream";
        }
        return string;
    }

    public static String getHttpDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss zzz", new Locale("en", "US"));
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(date);
    }

    private static String getExtension(File file) {
        String string = "";
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        if (n >= 0) {
            string = string2.substring(n);
        }
        return string.toLowerCase();
    }

    private void openLogPrintWriter() {
        Calendar calendar = Calendar.getInstance();
        this.m_dayOfMonth = calendar.get(5);
        String string = "http-" + calendar.get(1) + "-" + BattleShipsUtility.getZeroed(calendar.get(2) + 1) + "-" + BattleShipsUtility.getZeroed(this.m_dayOfMonth) + ".log";
        try {
            this.m_oLogPrintWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, true), "UTF8"));
            this.m_oLogPrintWriter.println(new Date().toString());
            this.m_oLogPrintWriter.println("TimeStamp Status RemoteAddress Request Referer");
            this.m_oLogPrintWriter.flush();
        }
        catch (Exception exception) {
            System.out.println("Error opening log file: " + exception.getMessage());
        }
    }

    private void closeLogPrintWriter() {
        if (this.m_oLogPrintWriter != null) {
            this.m_oLogPrintWriter.println();
            this.m_oLogPrintWriter.close();
        }
    }

    static {
        MIME_TYPES.put(".gif", "image/gif");
        MIME_TYPES.put(".jpg", "image/jpeg");
        MIME_TYPES.put(".png", "image/png");
        MIME_TYPES.put(".ico", "image/x-icon");
        MIME_TYPES.put(".html", "text/html");
        MIME_TYPES.put(".htm", "text/html");
        MIME_TYPES.put(".js", "application/x-javascript");
        MIME_TYPES.put(".au", "audio/basic");
        MIME_TYPES.put(".css", "text/css");
        MIME_TYPES.put(".cfg", "forbidden");
    }
}

